/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.node;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.document.node.AbstractMutableNode;
import ch.nolix.core.document.node.MutableNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.environment.filesystem.FileAccessor;
import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import java.util.function.Predicate;

public final class FileNode
extends AbstractMutableNode<FileNode> {
    private final IMutableNode<?> internalSpecification;
    private final FileAccessor fileAccessor;
    private final FileNode parentFileNode;

    public FileNode(String filePath) {
        if (!FileSystemAccessor.exists(filePath)) {
            this.fileAccessor = FileSystemAccessor.createFile(filePath);
        } else if (FileSystemAccessor.isFile(filePath)) {
            this.fileAccessor = new FileAccessor(filePath);
        } else {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(filePath, "is not a file");
        }
        this.internalSpecification = MutableNode.fromFile(filePath);
        this.parentFileNode = null;
    }

    private FileNode(FileNode parentFileNode, IMutableNode<?> internalSpecification) {
        Validator.assertThat(parentFileNode).isOfType(FileNode.class);
        Validator.assertThat(internalSpecification).thatIsNamed("internal specification").isNotNull();
        this.parentFileNode = parentFileNode;
        this.internalSpecification = internalSpecification;
        this.fileAccessor = null;
    }

    @Override
    public FileNode addChildNode(INode<?> childNode, INode<?> ... childNodes) {
        this.internalSpecification.addChildNode(childNode, childNodes);
        this.save();
        return this;
    }

    @Override
    public FileNode addChildNodeFromString(String string, String ... strings) {
        this.internalSpecification.addChildNodeFromString(string, strings);
        this.save();
        return this;
    }

    @Override
    public <N extends INode<?>> FileNode addChildNodes(Iterable<N> childNodes) {
        this.internalSpecification.addChildNodes(childNodes);
        this.save();
        return this;
    }

    @Override
    public FileNode addChildNodesFromStrings(Iterable<String> strings) {
        this.internalSpecification.addChildNodesFromStrings(strings);
        this.save();
        return this;
    }

    @Override
    public INode<?> asWithHeader(String header) {
        return Node.withHeaderAndChildNodes(header, this.getStoredChildNodes());
    }

    @Override
    public String getHeader() {
        return this.internalSpecification.getHeader();
    }

    @Override
    public ContainerView<FileNode> getStoredChildNodes() {
        return ContainerView.forIterable(this.internalSpecification.getStoredChildNodes().to(a -> new FileNode(this.getStoredRootFileNode(), (IMutableNode<?>)a)), new Iterable[0]);
    }

    @Override
    public boolean hasHeader() {
        return this.internalSpecification.hasHeader();
    }

    @Override
    public FileNode removeAndGetStoredFirstChildNodeThat(Predicate<INode<?>> selector) {
        Object attribute = this.internalSpecification.removeAndGetStoredFirstChildNodeThat(selector::test);
        this.save();
        return new FileNode(this, (IMutableNode<?>)attribute);
    }

    @Override
    public void removeFirstChildNodeThat(Predicate<INode<?>> selector) {
        this.internalSpecification.removeFirstChildNodeThat(selector);
        this.save();
    }

    @Override
    public void removeFirstChildNodeWithHeader(String header) {
        this.internalSpecification.removeFirstChildNodeWithHeader(header);
    }

    @Override
    public void removeChildNodes() {
        this.internalSpecification.removeChildNodes();
        this.save();
    }

    @Override
    public void removeHeader() {
        this.internalSpecification.removeHeader();
        this.save();
    }

    @Override
    public void replaceFirstChildNodeWithGivenHeaderByGivenNode(String header, INode<?> node) {
        this.internalSpecification.replaceFirstChildNodeWithGivenHeaderByGivenNode(header, node);
        this.save();
    }

    @Override
    public void reset() {
        this.removeHeader();
        this.removeChildNodes();
    }

    @Override
    public FileNode setHeader(String header) {
        this.internalSpecification.setHeader(header);
        this.save();
        return this;
    }

    @Override
    protected FileNode asConcrete() {
        return this;
    }

    private FileNode getStoredRootFileNode() {
        if (!this.isRootFileNode()) {
            return this.parentFileNode.getStoredRootFileNode();
        }
        return this;
    }

    private boolean isRootFileNode() {
        return this.fileAccessor != null;
    }

    private void save() {
        if (!this.isRootFileNode()) {
            this.save();
        } else {
            this.fileAccessor.overwriteFile(this.internalSpecification.toFormattedString());
        }
    }
}

