/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.perfomancevalidator;

import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.performanceanalysis.PerformanceAnalyzer;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.errorcontrol.performanceanalysis.IPerformanceAnalyzer;
import ch.nolix.coreapi.errorcontrol.performanceanalysis.TimeComplexityFunctionCatalog;
import ch.nolix.coreapi.errorcontrol.performancevalidator.IActionMediator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongToDoubleFunction;

public final class ActionMediator<O>
implements IActionMediator {
    private static final IPerformanceAnalyzer PERFORMANCE_ANALYZER = new PerformanceAnalyzer();
    private final IntFunction<O> objectSupplier;
    private final Consumer<O> action;

    private ActionMediator(IntFunction<O> objectSupplier, Consumer<O> action) {
        Validator.assertThat(objectSupplier).thatIsNamed("object supplier").isNotNull();
        Validator.assertThat(action).thatIsNamed("action").isNotNull();
        this.objectSupplier = objectSupplier;
        this.action = action;
    }

    public static <O2> IActionMediator forObjectSupplierAndAction(IntFunction<O2> objectSupplier, Consumer<O2> action) {
        return new ActionMediator<O2>(objectSupplier, action);
    }

    @Override
    public void hasConstantOrLowerTimeComplexity() {
        this.hasGivenOrLowerTimeComplexity(TimeComplexityFunctionCatalog.CONSTANT);
    }

    @Override
    public void hasGivenOrLowerTimeComplexity(LongToDoubleFunction timeComplexityFunction) {
        boolean passed = PERFORMANCE_ANALYZER.onObjectsFromObjectSupplierActionHasGivenOrLowerTimeComplexity(this.objectSupplier, this.action, timeComplexityFunction);
        if (!passed) {
            throw GeneralException.withErrorMessage("The action of the current ActionMediator does not have the given or a lower time complexity.");
        }
    }

    @Override
    public void hasLinearOrLowerTimeComplexity() {
        this.hasGivenOrLowerTimeComplexity(TimeComplexityFunctionCatalog.LINEAR);
    }

    @Override
    public void hasQuadraticOrLowerTimeComplexity() {
        this.hasGivenOrLowerTimeComplexity(TimeComplexityFunctionCatalog.QUADRATIC);
    }
}

