/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.independent.list;

import ch.nolix.core.independent.arraytool.ArrayValidator;
import ch.nolix.core.independent.list.ImmutableListIterator;
import java.util.Arrays;
import java.util.Iterator;

public final class ImmutableList<E>
implements Iterable<E> {
    private static final ArrayValidator ARRAY_VALIDATOR = new ArrayValidator();
    private final E[] elements;

    private ImmutableList() {
        this.elements = new Object[0];
        ARRAY_VALIDATOR.assertDoesNotContainNull(this.elements);
    }

    private ImmutableList(E[] paramElements) {
        this.elements = (Object[])paramElements.clone();
        ARRAY_VALIDATOR.assertDoesNotContainNull(this.elements);
    }

    private ImmutableList(E element, E[] paramElements) {
        this.elements = Arrays.copyOfRange(paramElements, 0, 1 + paramElements.length);
        this.elements[paramElements.length] = element;
        ARRAY_VALIDATOR.assertDoesNotContainNull(paramElements);
    }

    public static <E2> ImmutableList<E2> createEmptyList() {
        return new ImmutableList();
    }

    public static <E2> ImmutableList<E2> withElement(E2 element, E2 ... elements) {
        return new ImmutableList<E2>(element, elements);
    }

    public static <E2> ImmutableList<E2> withElements(E2[] array) {
        return new ImmutableList<E2>(array);
    }

    @Override
    public Iterator<E> iterator() {
        return ImmutableListIterator.forArray(this.elements);
    }
}

