/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.independent.list;

import ch.nolix.core.independent.list.ListIterator;
import ch.nolix.core.independent.list.ListNode;
import java.util.Iterator;
import java.util.function.Function;

public final class List<E>
implements Iterable<E> {
    private int elementCount;
    private ListNode<E> beginNode;
    private ListNode<E> endNode;

    public List() {
    }

    public List(E element) {
        this.addAtBegin(element);
    }

    public List(E[] elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            this.addAtBegin(e);
            ++n2;
        }
    }

    public static String[] createArrayFromList(List<String> list) {
        String[] array = new String[list.getElementCount()];
        int index = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String e;
            array[index] = e = iterator.next();
            ++index;
        }
        return array;
    }

    public static <E2> List<E2> withElements(Iterable<E2> elements) {
        List<E2> list = new List<E2>();
        for (E2 e : elements) {
            list.addAtEnd(e);
        }
        return list;
    }

    public void addAtBegin(E element) {
        ListNode<E> node = new ListNode<E>(element);
        if (this.isEmpty()) {
            this.beginNode = node;
            this.endNode = node;
        } else {
            node.setNextNode(this.beginNode);
            this.beginNode = node;
        }
        ++this.elementCount;
    }

    public void addAtEnd(E element) {
        ListNode<E> node = new ListNode<E>(element);
        if (this.isEmpty()) {
            this.beginNode = node;
            this.endNode = node;
        } else {
            this.endNode.setNextNode(node);
            this.endNode = node;
        }
        ++this.elementCount;
    }

    public void clear() {
        this.beginNode = null;
        this.endNode = null;
        this.elementCount = 0;
    }

    public List<E> getCopy() {
        List<E> list = new List<E>();
        for (E e : this) {
            list.addAtEnd(e);
        }
        return list;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public E getStoredFirst() {
        this.assertIsNotEmpty();
        return this.beginNode.getStoredElement();
    }

    public boolean isEmpty() {
        return this.beginNode == null;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.isEmpty()) {
            return ListIterator.forEmptyList();
        }
        return ListIterator.forStartNode(this.beginNode);
    }

    public void removeFirst() {
        this.assertIsNotEmpty();
        if (!this.beginNode.hasNextNode()) {
            this.beginNode = null;
            this.endNode = null;
        } else {
            this.beginNode = this.beginNode.getStoredNextNode();
        }
        --this.elementCount;
    }

    public void removeFirstOccurrenceOf(E element) {
        if (!this.isEmpty()) {
            this.removeFirstOccuranceOfWhenContainsAny(element);
        }
    }

    public byte[] toByteArray(Function<E, Byte> byteMapper) {
        if (byteMapper == null) {
            throw new IllegalArgumentException("The given byteMapper is null.");
        }
        byte[] array = new byte[this.getElementCount()];
        int index = 0;
        for (E e : this) {
            array[index] = e == null ? (byte)0 : byteMapper.apply(e);
            ++index;
        }
        return array;
    }

    private void assertIsNotEmpty() {
        if (this.isEmpty()) {
            throw new IllegalStateException("The current List is empty.");
        }
    }

    private void removeFirstOccuranceOfWhenContainsAny(E element) {
        if (this.beginNode.contains(element)) {
            this.removeFirst();
        } else {
            this.removeFirstOccuranceOfWhenIsNotFirst(element);
        }
    }

    private void removeFirstOccuranceOfWhenIsNotFirst(E element) {
        ListNode<E> iteratorNode = this.beginNode;
        while (iteratorNode.hasNextNode()) {
            ListNode<E> nextNode = iteratorNode.getStoredNextNode();
            if (nextNode.contains(element)) {
                if (!nextNode.hasNextNode()) {
                    iteratorNode.removeNextNode();
                    this.endNode = iteratorNode;
                } else {
                    iteratorNode.setNextNode(nextNode.getStoredNextNode());
                }
                --this.elementCount;
                return;
            }
            iteratorNode = nextNode;
        }
    }
}

