/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.independent.list;

import ch.nolix.core.independent.list.ListNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ListIterator<E>
implements Iterator<E> {
    private ListNode<E> nextNode;

    private ListIterator() {
    }

    private ListIterator(ListNode<E> startNode) {
        this.nextNode = startNode;
    }

    public static <E2> ListIterator<E2> forEmptyList() {
        return new ListIterator();
    }

    public static <E2> ListIterator<E2> forStartNode(ListNode<E2> startNode) {
        return new ListIterator<E2>(startNode);
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public E next() throws NoSuchElementException {
        this.assertHasNext();
        E element = this.nextNode.getStoredElement();
        this.nextNode = this.nextNode.hasNextNode() ? this.nextNode.getStoredNextNode() : null;
        return element;
    }

    private void assertHasNext() throws NoSuchElementException {
        if (this.nextNode == null) {
            throw new NoSuchElementException("The current ListIterator does not have a next element.");
        }
    }
}

