/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.misc.english;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.misc.english.EnglishWordEndExaminer;

public final class EnglishNounTool {
    private static final EnglishWordEndExaminer ENGLISH_WORD_END_EXAMINER = new EnglishWordEndExaminer();

    public String getArticleOfNoun(String noun) {
        char firstLetter = noun.charAt(0);
        return this.getArticleOfNounWithFirstLetter(firstLetter);
    }

    public String getPluralOfNoun(String noun) {
        Validator.assertThat(noun).thatIsNamed("noun").isNotBlank();
        return switch (noun) {
            case "child" -> "children";
            case "foot" -> "feet";
            case "goose" -> "geese";
            case "mouse" -> "mice";
            case "tooth" -> "teeth";
            default -> this.getPluralOfNounDependingOnEnding(noun);
        };
    }

    private String getArticleOfNounWithFirstLetter(char firstLetter) {
        if (firstLetter < 'A' || firstLetter > 'Z' && firstLetter < 'a' || firstLetter > 'z') {
            throw InvalidArgumentException.forArgumentAndArgumentName(Character.valueOf(firstLetter), "letter");
        }
        return switch (firstLetter) {
            case 'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u' -> "an";
            default -> "a";
        };
    }

    private String getPluralOfNounDependingOnEnding(String noun) {
        if (noun.endsWith("man")) {
            return noun.substring(0, noun.length() - 3) + "men";
        }
        if (noun.endsWith("ef")) {
            return noun.substring(0, noun.length() - 1) + "ves";
        }
        if (this.pluralOfNounEndsWithEs(noun)) {
            return noun + "es";
        }
        if (ENGLISH_WORD_END_EXAMINER.endsWithVocalAndY(noun) || noun.endsWith("ff")) {
            return noun + "s";
        }
        if (noun.endsWith("y")) {
            return noun.substring(0, noun.length() - 1) + "ies";
        }
        if (noun.endsWith("f")) {
            return noun.substring(0, noun.length() - 1) + "ves";
        }
        if (noun.endsWith("s")) {
            return noun + "ses";
        }
        return noun + "s";
    }

    private boolean pluralOfNounEndsWithEs(String noun) {
        return noun.endsWith("sh") || noun.endsWith("ss") || noun.endsWith("x");
    }
}

