/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.AbstractEndPoint;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.net.endpointprotocol.MessageType;
import ch.nolix.coreapi.programcontrol.processproperty.TargetInfoState;

public abstract class AbstractNetEndPoint
extends AbstractEndPoint {
    private static final String RAW_MESSAGE_VARIABLE_NAME = "raw message";
    private boolean hasTargetInfo;

    AbstractNetEndPoint(TargetInfoState targetInfoState) {
        Validator.assertThat(targetInfoState).thatIsNamed(TargetInfoState.class).isNotNull();
        if (targetInfoState == TargetInfoState.RECEIVED_TARGET_INFO) {
            this.confirmReceivedTargetInfo();
        }
    }

    AbstractNetEndPoint(String target) {
        this.setCustomTargetSlot(target);
        this.confirmReceivedTargetInfo();
    }

    @Override
    public final void sendMessage(String message) {
        this.sendRawMessage(MessageType.CONTENT_MESSAGE.getPrefix() + message);
    }

    protected final boolean hasTargetInfo() {
        return this.hasTargetInfo;
    }

    protected final void sendRawMessage(char rawMessage) {
        this.sendRawMessage(String.valueOf(rawMessage));
    }

    protected abstract void sendRawMessage(String var1);

    protected final void sendTargetMessage() {
        this.sendRawMessage(this.getTargetMessage());
    }

    final void receiveRawMessageInBackground(String rawMessage) {
        FlowController.runInBackground(() -> this.receiveRawMessage(rawMessage));
    }

    private void confirmReceivedTargetInfo() {
        if (this.hasTargetInfo()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has already a target info");
        }
        this.hasTargetInfo = true;
    }

    private String getTargetMessage() {
        if (!this.hasCustomTargetSlot()) {
            return MessageType.DEFAULT_TARGET_MESSAGE.getPrefix();
        }
        return MessageType.TARGET_MESSAGE.getPrefix() + this.getCustomTargetSlot();
    }

    private void receiveMessage(String message) {
        this.assertIsOpen();
        this.getStoredReceiver().accept(message);
    }

    void receiveRawMessage(String rawMessage) {
        MessageType messageType = MessageType.forPrefix(rawMessage.substring(0, 1));
        switch (messageType) {
            case DEFAULT_TARGET_MESSAGE: {
                if (!rawMessage.equals(MessageType.DEFAULT_TARGET_MESSAGE.getPrefix())) {
                    throw InvalidArgumentException.forArgumentAndArgumentName(rawMessage, RAW_MESSAGE_VARIABLE_NAME);
                }
                this.confirmReceivedTargetInfo();
                break;
            }
            case TARGET_MESSAGE: {
                this.setCustomTargetSlot(rawMessage.substring(1));
                this.confirmReceivedTargetInfo();
                break;
            }
            case CONTENT_MESSAGE: {
                this.receiveMessage(rawMessage.substring(1));
                break;
            }
            case CLOSE_MESSAGE: {
                Validator.assertThat(rawMessage).thatIsNamed(RAW_MESSAGE_VARIABLE_NAME).hasLength(1);
                this.close();
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(rawMessage, RAW_MESSAGE_VARIABLE_NAME);
            }
        }
    }
}

