/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.Server;
import ch.nolix.core.net.endpoint.SocketHandler;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.programcontrol.worker.AbstractWorker;
import ch.nolix.coreapi.resourcecontrol.closecontroller.CloseStateRequestable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public final class ServerListener
extends AbstractWorker
implements CloseStateRequestable {
    private static final SocketHandler SOCKET_HANDLER = new SocketHandler();
    private final Server parentServer;

    private ServerListener(Server parentServer) {
        Validator.assertThat(parentServer).thatIsNamed("parent server").isNotNull();
        this.parentServer = parentServer;
        this.start();
    }

    public static ServerListener forServer(Server server) {
        return new ServerListener(server);
    }

    @Override
    public boolean isClosed() {
        return this.parentServer.isClosed();
    }

    @Override
    protected void run() {
        ServerSocket serverSocket = this.parentServer.internalGetStoredServerSocket();
        try {
            while (this.isOpen()) {
                Socket socket = serverSocket.accept();
                this.handleSocket(socket);
            }
        }
        catch (SocketException socketException) {
            this.parentServer.close();
        }
        catch (IOException ioException) {
            this.parentServer.close();
            throw WrapperException.forError(ioException);
        }
    }

    private void handleSocket(Socket socket) {
        FlowController.runInBackground(() -> SOCKET_HANDLER.handleSocketForServer(socket, this.parentServer));
    }
}

