/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ClosedArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.baseendpoint.AbstractBaseEndPoint;
import ch.nolix.coreapi.net.endpoint2.IEndPoint;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class AbstractEndPoint
extends AbstractBaseEndPoint
implements IEndPoint {
    private static final long REPLIER_GETTING_DELAY_IN_MILLISECONDS = 5000L;
    private Function<String, String> replier;

    @Override
    public boolean hasReplier() {
        return this.replier != null;
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public void setReplier(UnaryOperator<String> replier) {
        Validator.assertThat(replier).thatIsNamed("replier").isNotNull();
        this.replier = replier;
    }

    protected final void assertIsOpen() {
        if (this.isClosed()) {
            throw ClosedArgumentException.forArgument(this);
        }
    }

    protected final Function<String, String> getStoredReplier() {
        long startTimeInMilliseconds = System.currentTimeMillis();
        while (!this.hasReplier()) {
            System.out.flush();
            if (System.currentTimeMillis() - startTimeInMilliseconds <= 5000L) continue;
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "replier");
        }
        return this.replier;
    }
}

