/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.SocketEndPoint;
import ch.nolix.core.net.endpoint2.AbstractEndPoint;
import ch.nolix.core.net.endpoint2.Package;
import ch.nolix.coreapi.net.endpoint.IEndPoint;
import ch.nolix.coreapi.net.endpoint2protocol.MessageRole;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;

public final class NetEndPoint
extends AbstractEndPoint {
    private int nextSentPackageIndex = 1;
    private final IEndPoint internalEndPoint;
    private final LinkedList<Package> receivedPackages = LinkedList.createEmpty();

    public NetEndPoint(int port) {
        this(new SocketEndPoint(port));
    }

    public NetEndPoint(int port, String target) {
        this(new SocketEndPoint(port, target));
    }

    public NetEndPoint(String ip) {
        this(new SocketEndPoint(ip));
    }

    public NetEndPoint(String ip, int port) {
        this(new SocketEndPoint(ip, port));
    }

    public NetEndPoint(String ip, int port, String target) {
        this(new SocketEndPoint(ip, port, target));
    }

    NetEndPoint(IEndPoint internalEndPoint) {
        Validator.assertThat(internalEndPoint).thatIsNamed("internal EndPoint").isNotNull();
        this.internalEndPoint = internalEndPoint;
        this.createCloseDependencyTo(internalEndPoint);
        internalEndPoint.setReceiver(this::receive);
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.internalEndPoint.getConnectionType();
    }

    @Override
    public String getCustomTargetSlot() {
        return this.internalEndPoint.getCustomTargetSlot();
    }

    @Override
    public PeerType getPeerType() {
        return this.internalEndPoint.getPeerType();
    }

    @Override
    public SecurityMode getSecurityMode() {
        return this.internalEndPoint.getSecurityMode();
    }

    public boolean isNetEndPoint() {
        return this.internalEndPoint.isSocketEndPoint();
    }

    @Override
    public String getReplyForRequest(String message) {
        return this.sendAndWaitToReply(message);
    }

    @Override
    public boolean hasCustomTargetSlot() {
        return this.internalEndPoint.hasCustomTargetSlot();
    }

    IEndPoint getStoredInternalEndPoint() {
        return this.internalEndPoint;
    }

    void receive(String message) {
        this.receive(Package.createPackageFromString(message));
    }

    LinkedList<Package> getStoredReceivedPackages() {
        return this.receivedPackages;
    }

    int getNextSentPackageIndex() {
        if (this.nextSentPackageIndex == Integer.MAX_VALUE) {
            this.nextSentPackageIndex = 0;
        }
        return this.nextSentPackageIndex++;
    }

    void receive(Package paramPackage) {
        switch (paramPackage.getMessageRole()) {
            case RESPONSE_EXPECTING_MESSAGE: {
                this.receiveResponseExpectingMessage(paramPackage);
                break;
            }
            default: {
                this.getStoredReceivedPackages().addAtEnd(paramPackage);
            }
        }
    }

    private Package getAndRemoveReceivedPackage(int index) {
        return this.getStoredReceivedPackages().removeAndGetStoredFirst(rp -> rp.hasIndex(index));
    }

    private boolean receivedPackage(int index) {
        return this.getStoredReceivedPackages().containsAny(rp -> rp.hasIndex(index));
    }

    private void receiveResponseExpectingMessage(Package paramPackage) {
        try {
            String reply = this.getStoredReplier().apply((String)paramPackage.getStoredContent());
            if (this.isOpen()) {
                this.send(new Package(paramPackage.getIndex(), MessageRole.SUCCESS_RESPONSE, reply));
            }
        }
        catch (Throwable error) {
            String responseMessage = error.getMessage();
            this.send(new Package(paramPackage.getIndex(), MessageRole.ERROR_RESPONSE, responseMessage));
        }
    }

    private void send(Package paramPackage) {
        this.internalEndPoint.sendMessage(paramPackage.toString());
    }

    private String sendAndWaitToReply(String message) {
        int index = this.getNextSentPackageIndex();
        this.send(new Package(index, MessageRole.RESPONSE_EXPECTING_MESSAGE, message));
        Package response = this.waitToAndGetAndRemoveReceivedPackage(index);
        if (response == null) {
            return null;
        }
        switch (response.getMessageRole()) {
            case SUCCESS_RESPONSE: {
                break;
            }
            case ERROR_RESPONSE: {
                throw GeneralException.withErrorMessage((String)response.getStoredContent());
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(response, "reply");
            }
        }
        return (String)response.getStoredContent();
    }

    private Package waitToAndGetAndRemoveReceivedPackage(int index) {
        while (!this.receivedPackage(index)) {
            if (this.isClosed()) {
                return null;
            }
            System.err.flush();
        }
        return this.getAndRemoveReceivedPackage(index);
    }
}

