/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint3;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.document.node.AbstractNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint3.AbstractEndPoint;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.endpoint2.IEndPoint;
import ch.nolix.coreapi.net.endpoint3.IDataProviderController;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;

public final class NetEndPoint
extends AbstractEndPoint {
    private final IEndPoint internalEndPoint;

    public NetEndPoint(int port) {
        this("::1", port);
    }

    public NetEndPoint(int port, String targetSlot) {
        this("::1", port, targetSlot);
    }

    public NetEndPoint(String ip) {
        this(new ch.nolix.core.net.endpoint2.NetEndPoint(ip));
    }

    public NetEndPoint(String ip, int port) {
        this(new ch.nolix.core.net.endpoint2.NetEndPoint(ip, port));
    }

    public NetEndPoint(String ip, int port, String targetSlot) {
        this(new ch.nolix.core.net.endpoint2.NetEndPoint(ip, port, targetSlot));
    }

    NetEndPoint(IEndPoint internalEndPoint) {
        Validator.assertThat(internalEndPoint).thatIsNamed("internal end point").isNotNull();
        this.internalEndPoint = internalEndPoint;
        internalEndPoint.setReplier(this::receiveAndGetReply);
        this.createCloseDependencyTo(internalEndPoint);
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.internalEndPoint.getConnectionType();
    }

    @Override
    public String getCustomTargetSlot() {
        return this.internalEndPoint.getCustomTargetSlot();
    }

    @Override
    public INode<?> getDataForRequest(IChainedNode request) {
        ImmutableList<IChainedNode> requests = ImmutableList.withElement(request, new IChainedNode[0]);
        return (INode)this.getDataForRequests(requests).getStoredOne();
    }

    @Override
    public IContainer<? extends INode<?>> getDataForRequests(IChainedNode request, IChainedNode ... requests) {
        ImmutableList<IChainedNode> concatenatedRequests = ImmutableList.withElement(request, requests);
        return this.getDataForRequests(concatenatedRequests);
    }

    @Override
    public IContainer<? extends INode<?>> getDataForRequests(Iterable<? extends IChainedNode> requests) {
        String message = "MultiDataRequest(" + requests.toString() + ")";
        Node reply = Node.fromString(this.internalEndPoint.getReplyForRequest(message));
        switch (reply.getHeader()) {
            case "MultiData": {
                break;
            }
            case "Error": {
                throw GeneralException.withErrorMessage(reply.getSingleChildNodeHeader());
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(reply, "reply");
            }
        }
        return reply.getStoredChildNodes();
    }

    @Override
    public PeerType getPeerType() {
        return this.internalEndPoint.getPeerType();
    }

    @Override
    public SecurityMode getSecurityMode() {
        return this.internalEndPoint.getSecurityMode();
    }

    @Override
    public boolean hasCustomTargetSlot() {
        return this.internalEndPoint.hasCustomTargetSlot();
    }

    @Override
    public void runCommand(IChainedNode command) {
        this.runCommands(LinkedList.withElement(command, new IChainedNode[0]));
    }

    @Override
    public void runCommands(Iterable<? extends IChainedNode> commands) {
        block10: {
            String message = "Commands(" + String.valueOf(ContainerView.forIterable(commands, new Iterable[0])) + ")";
            String replyAsString = this.internalEndPoint.getReplyForRequest(message);
            if (replyAsString == null) break block10;
            Node reply = Node.fromString(replyAsString);
            switch (reply.getHeader()) {
                case "Error": {
                    throw GeneralException.withErrorMessage(reply.getSingleChildNodeHeader());
                }
                default: {
                    throw InvalidArgumentException.forArgumentAndArgumentName(reply, "reply");
                }
                case "Done": 
            }
        }
    }

    private String receiveAndGetReply(String message) {
        try {
            return this.receiveAndGetReply(ChainedNode.fromString(message));
        }
        catch (Throwable error) {
            Logger.logError(error);
            if (error.getMessage() == null) {
                return "Error";
            }
            return "Error(" + AbstractNode.getEscapeStringFor(error.getMessage()) + ")";
        }
    }

    private String receiveAndGetReply(ChainedNode message) {
        IDataProviderController receiverController = this.getStoredReceiverController();
        switch (message.getHeader()) {
            case "Commands": {
                for (ChainedNode a : message.getChildNodes()) {
                    receiverController.runCommand(a);
                }
                return "Done";
            }
            case "MultiDataRequest": {
                return "MultiData" + StringTool.getInParentheses(receiverController.getDataForRequests(message.getChildNodes()).toString(), new Object[0]);
            }
        }
        throw InvalidArgumentException.forArgumentAndArgumentName(message, "message");
    }
}

