/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.websocket;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.net.websocket.WebSocketFrame;
import ch.nolix.coreapi.state.staterequest.CompletenessRequestable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public final class WebSocketCompleteMessage
implements CompletenessRequestable {
    private boolean complete;
    private final LinkedList<Byte> message = LinkedList.createEmpty();

    public WebSocketCompleteMessage(BooleanSupplier isOpenFunction, InputStream inputStream, Consumer<WebSocketFrame> controlFrameTaker) {
        while (isOpenFunction.getAsBoolean() && this.isIncomplete()) {
            WebSocketFrame frame = new WebSocketFrame(inputStream);
            this.addFrame(frame, controlFrameTaker);
        }
    }

    public String getMessage() {
        return new String(this.getMessageAsByteArray(), StandardCharsets.UTF_8);
    }

    public byte[] getMessageAsByteArray() {
        byte[] byteArray = new byte[this.message.getCount()];
        int i = 0;
        for (Byte b : this.message) {
            byteArray[i] = b;
            ++i;
        }
        return byteArray;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    private void addDataFrame(WebSocketFrame dataFrame) {
        byte[] byArray = dataFrame.getPayload();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.message.addAtEnd(b);
            ++n2;
        }
        if (dataFrame.isFinalFragment()) {
            this.complete = true;
        }
    }

    private void addFrame(WebSocketFrame frame, Consumer<WebSocketFrame> controlFrameTaker) {
        switch (frame.getFrameType()) {
            case CONTROL_FRAME: {
                controlFrameTaker.accept(frame);
                break;
            }
            case DATA_FRAME: {
                this.addDataFrame(frame);
            }
        }
    }
}

