/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;

public final class JobMerger {
    public Runnable createMergedJobForJobs(IContainer<Runnable> jobs) {
        Validator.assertThat(jobs).thatIsNamed("jobs").isNotNull();
        return () -> this.runJobs(jobs);
    }

    private void runJobs(IContainer<Runnable> jobs) {
        int i = 1;
        while (i <= jobs.getCount()) {
            try {
                ((Runnable)jobs.getStoredAtOneBasedIndex(i)).run();
            }
            catch (Throwable error) {
                throw WrapperException.forErrorMessageAndError("An error occured by running the " + i + "th job of the given " + jobs.getCount() + " jobs.", error);
            }
            ++i;
        }
    }
}

