/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.future;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.programcontrol.future.IFuture;

public abstract class AbstractFuture
implements IFuture {
    @Override
    public final boolean isFinishedSuccessfully() {
        return this.isFinished() && !this.caughtError();
    }

    @Override
    public final boolean isFinishedWithError() {
        return this.isFinished() && this.caughtError();
    }

    @Override
    public final void waitUntilIsFinishedSuccessfully() {
        this.waitUntilIsFinished();
        this.handleProbableError();
    }

    @Override
    public final void waitUntilIsFinishedSuccessfully(int timeoutInMilliseconds) {
        this.waitUntilIsFinished(timeoutInMilliseconds);
        this.handleProbableError();
    }

    private void handleError() {
        if (this.getError().getMessage() == null || this.getError().getMessage().isBlank()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has caught a '" + this.getError().getClass().getName() + "'");
        }
        throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has caught the error '" + this.getError().getClass().getName() + ": " + this.getError().getMessage() + "'");
    }

    private void handleProbableError() {
        if (this.caughtError()) {
            this.handleError();
        }
    }
}

