/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnconnectedArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint3.AbstractEndPoint;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.endpoint3.IEndPoint;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.application.main.ClientDataProviderController;
import ch.nolix.systemapi.application.client.IClient;

public abstract class AbstractClient<C extends AbstractClient<C>>
implements IClient {
    private final ICloseController closeController = CloseController.forElement(this);
    private IEndPoint nullableEndPoint;

    @Override
    public final SecurityMode getSecurityMode() {
        return this.getStoredEndPoint().getSecurityMode();
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final String getUrlInstanceNameOfTargetApplication() {
        return this.getStoredEndPoint().getCustomTargetSlot();
    }

    @Override
    public final boolean hasRequestedConnection() {
        return this.getStoredEndPoint().isFrontendEndPoint();
    }

    @Override
    public final boolean hasUrlInstanceNameOfTargetApplication() {
        return this.getStoredEndPoint().hasCustomTargetSlot();
    }

    @Override
    public final boolean isClosed() {
        return this.isConnected() && this.getStoredEndPoint().isClosed();
    }

    protected final INode<?> getDataFromCounterpart(IChainedNode request) {
        return this.getStoredEndPoint().getDataForRequest(request);
    }

    protected abstract INode<?> getDataFromHere(IChainedNode var1);

    protected abstract void runHere(IChainedNode var1);

    protected final void runOnCounterpart(IChainedNode command) {
        this.getStoredEndPoint().runCommand(command);
    }

    protected final void runOnCounterpart(ChainedNode command, ChainedNode ... commands) {
        this.getStoredEndPoint().runCommands(command, commands);
    }

    protected final void runOnCounterpart(Iterable<? extends IChainedNode> commands) {
        this.getStoredEndPoint().runCommands(commands);
    }

    final void setEndPoint(IEndPoint endPoint) {
        Validator.assertThat(endPoint).thatIsNamed(AbstractEndPoint.class).isNotNull();
        this.assertIsNotConnected();
        this.nullableEndPoint = endPoint;
        this.createCloseDependencyTo(endPoint);
        endPoint.setReceivingDataProviderController(new ClientDataProviderController(this));
    }

    private void assertIsConnected() {
        if (!this.isConnected()) {
            throw UnconnectedArgumentException.forArgument(this);
        }
    }

    private void assertIsNotConnected() {
        if (this.isConnected()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is already connected");
        }
    }

    private IEndPoint getStoredEndPoint() {
        this.assertIsConnected();
        return this.nullableEndPoint;
    }

    private boolean isConnected() {
        return this.nullableEndPoint != null;
    }
}

