/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.multistateconfiguration;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;

final class State<S extends Enum<S>>
implements INameHolder {
    private static final String NAME = "State";
    private final String qualifyingPrefix;
    private final int index;
    private final S enumValue;

    private State(String prefix, int index, S enumValue) {
        Validator.assertThat(prefix).thatIsNamed("prefix").isNotBlank();
        Validator.assertThat(index).thatIsNamed("index").isNotNegative();
        Validator.assertThat(enumValue).thatIsNamed("enum value").isNotNull();
        this.qualifyingPrefix = prefix;
        this.index = index;
        this.enumValue = enumValue;
    }

    public static <S2 extends Enum<S2>> State<S2> withQualifyingPrefixAndIndexAndEnumValue(String qualifyingPrefix, int index, S2 enumValue) {
        return new State<S2>(qualifyingPrefix, index, enumValue);
    }

    public S getEnumValue() {
        return this.enumValue;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getQualifiedName() {
        return this.getQualifyingPrefix() + this.getName();
    }

    public String getQualifyingPrefix() {
        return this.qualifyingPrefix;
    }

    public boolean hasEnumValue(S enumValue) {
        return this.getEnumValue() == enumValue;
    }
}

