/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.optionalattribute.IOptionalHeaderHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.state.statemutation.Clearable;
import ch.nolix.system.element.property.AbstractValue;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MultiValue<V>
extends AbstractValue<V>
implements Clearable {
    private final Consumer<V> adderMethod;
    private final LinkedList<V> values = LinkedList.createEmpty();

    public MultiValue(String name, Consumer<V> adderMethod, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name, valueCreator, specificationCreator);
        Validator.assertThat(adderMethod).thatIsNamed("adder method").isNotNull();
        this.adderMethod = adderMethod;
    }

    public static MultiValue<Integer> forInts(String name, Consumer<Integer> adderMethod) {
        return new MultiValue<Integer>(name, adderMethod, INode::toInt, Node::withHeader);
    }

    public static MultiValue<String> forStrings(String name, Consumer<String> adderMethod) {
        return new MultiValue<String>(name, adderMethod, IOptionalHeaderHolder::getHeader, Node::withHeader);
    }

    public void add(V value) {
        this.values.addAtEnd(value);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public IContainer<V> getStoredValues() {
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    public void remove(V value) {
        this.values.removeStrictlyFirstOccurrenceOf(value);
    }

    public V removeAndGetRefLast() {
        return this.values.removeAndGetStoredLast();
    }

    public MultiValue<V> removeLast() {
        this.values.removeLast();
        return this;
    }

    @Override
    protected void addOrChangeValue(V value) {
        this.adderMethod.accept(value);
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        for (Object v : this.getStoredValues()) {
            Node specification = Node.withHeaderAndChildNodes(this.getName(), ((INode)this.specificationCreator.apply(v)).getStoredChildNodes());
            list.addAtEnd(specification);
        }
    }
}

