/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.box;

import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.gui.box.Corner;
import ch.nolix.systemapi.gui.box.ICornerShadow;
import ch.nolix.systemapi.gui.location.Location;

public final class CornerShadow
extends AbstractElement
implements ICornerShadow {
    private static final Corner DEFAULT_CORNER = Corner.BOTTOM_RIGHT;
    public static final Location DEFAULT_LOCATION = Location.OUTSIDE;
    private static final int DEFAULT_SIDE_THICKNESS = 10;
    private static final int DEFAULT_BLUR_RADIUS = 0;
    private static final Color DEFAULT_COLOR = X11ColorCatalog.BLACK;
    private static final String CORNER_HEADER = "Corner";
    private static final String LOCATION_HEADER = "Location";
    private static final String SIDE1_THICKNESS_HEADER = "Side1Thickness";
    private static final String SIDE2_THICKNESS_HEADER = "Side2Thickness";
    private static final String BLUR_RADIUS_HEADER = "BlurRadius";
    private static final String COLOR_HEADER = "Color";
    private final Corner corner;
    private final Location location;
    private final int side1Thickness;
    private final int side2Thickness;
    private final int blurRadius;
    private final Color color;

    private CornerShadow(Corner corner, Location location, int side1Thickness, int side2Thickness, int blurRadius, IColor color) {
        Validator.assertThat(corner).thatIsNamed(Corner.class).isNotNull();
        Validator.assertThat(location).thatIsNamed(Location.class).isNotNull();
        Validator.assertThat(side1Thickness).thatIsNamed("side 1 thickness").isNotNegative();
        Validator.assertThat(side2Thickness).thatIsNamed("side 2 thickness").isNotNegative();
        Validator.assertThat(blurRadius).thatIsNamed("blur radius").isNotNegative();
        this.corner = corner;
        this.location = location;
        this.side1Thickness = side1Thickness;
        this.side2Thickness = side2Thickness;
        this.blurRadius = blurRadius;
        this.color = Color.fromColor(color);
    }

    public static CornerShadow fromCornerShadow(ICornerShadow cornerShadow) {
        if (cornerShadow instanceof CornerShadow) {
            CornerShadow localCornerShadow = (CornerShadow)cornerShadow;
            return localCornerShadow;
        }
        Corner corner = cornerShadow.getCorner();
        Location location = cornerShadow.getLocation();
        int side1Thickness = cornerShadow.getSide1Thickness();
        int side2Thickness = cornerShadow.getSide2Thickness();
        int blurRadius = cornerShadow.getBlurRadius();
        IColor color = cornerShadow.getColor();
        return CornerShadow.withCornerAndLocationAndSide1ThicknessAnsSide2ThicknessAndBlurRadiusAndColor(corner, location, side1Thickness, side2Thickness, blurRadius, color);
    }

    public static CornerShadow fromSpecification(INode<?> specification) {
        Corner corner = DEFAULT_CORNER;
        Location location = DEFAULT_LOCATION;
        int side1Thickness = 10;
        int side2Thickness = 10;
        int blurRadius = 0;
        Color color = DEFAULT_COLOR;
        IContainer<?> attributes = specification.getStoredChildNodes();
        for (INode a : attributes) {
            String header;
            switch (header = a.getHeader()) {
                case "Corner": {
                    corner = Corner.fromSpecification(a);
                    break;
                }
                case "Location": {
                    location = Location.fromSpecification(a);
                    break;
                }
                case "Side1Thickness": {
                    side1Thickness = a.getSingleChildNodeAsInt();
                    break;
                }
                case "Side2Thickness": {
                    side2Thickness = a.getSingleChildNodeAsInt();
                    break;
                }
                case "BlurRadius": {
                    blurRadius = a.getSingleChildNodeAsInt();
                    break;
                }
                case "Color": {
                    color = Color.fromSpecification(a);
                    break;
                }
                default: {
                    throw InvalidArgumentException.forArgumentAndArgumentName(a, "attribute");
                }
            }
        }
        return CornerShadow.withCornerAndLocationAndSide1ThicknessAnsSide2ThicknessAndBlurRadiusAndColor(corner, location, side1Thickness, side2Thickness, blurRadius, color);
    }

    public static CornerShadow withCornerAndLocationAndSide1ThicknessAnsSide2ThicknessAndBlurRadiusAndColor(Corner corner, Location location, int side1Thickness, int side2Thickness, int blurRadius, IColor color) {
        return new CornerShadow(corner, location, side1Thickness, side2Thickness, blurRadius, color);
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return ArrayList.withElement(Node.fromEnum(this.getCorner()), Node.fromEnum(this.getLocation()), Node.withHeaderAndChildNode(SIDE1_THICKNESS_HEADER, this.getSide1Thickness()), Node.withHeaderAndChildNode(SIDE2_THICKNESS_HEADER, this.getSide2Thickness()), Node.withHeaderAndChildNode(BLUR_RADIUS_HEADER, this.getBlurRadius()), this.getColor().getSpecification());
    }

    @Override
    public int getBlurRadius() {
        return this.blurRadius;
    }

    @Override
    public IColor getColor() {
        return this.color;
    }

    @Override
    public Corner getCorner() {
        return this.corner;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public int getSide1Thickness() {
        return this.side1Thickness;
    }

    @Override
    public int getSide2Thickness() {
        return this.side2Thickness;
    }
}

