/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.midschemaview.modelsearcher;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.midschemaview.modelsearcher.DatabaseViewSearcher;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.DatabaseViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.IDatabaseViewSearcher;
import ch.nolix.systemapi.midschemaview.modelsearcher.IDatabaseViewSearcherForDatabaseView;

public final class DatabaseViewSearcherForDatabaseView
implements IDatabaseViewSearcherForDatabaseView {
    private static final IDatabaseViewSearcher DATABASE_VIEW_SEARCHER = new DatabaseViewSearcher();
    private final DatabaseViewDto databaseView;

    private DatabaseViewSearcherForDatabaseView(DatabaseViewDto databaseView) {
        Validator.assertThat(databaseView).thatIsNamed("database view").isNotNull();
        this.databaseView = databaseView;
    }

    public static DatabaseViewSearcherForDatabaseView forDatabaseView(DatabaseViewDto databaseView) {
        return new DatabaseViewSearcherForDatabaseView(databaseView);
    }

    @Override
    public ColumnViewDto getColumnViewByTableNameAndColumnId(String tableName, String columnId) {
        return DATABASE_VIEW_SEARCHER.getColumnViewByTableNameAndColumnId(this.databaseView, tableName, columnId);
    }

    @Override
    public ColumnViewDto getColumnViewByTableNameAndColumnName(String tableName, String columnName) {
        return DATABASE_VIEW_SEARCHER.getColumnViewByTableNameAndColumnName(this.databaseView, tableName, columnName);
    }

    @Override
    public TableViewDto getTableViewByTableId(String tableId) {
        return DATABASE_VIEW_SEARCHER.getTableViewByTableId(this.databaseView, tableId);
    }

    @Override
    public TableViewDto getTableViewByTableName(String tableName) {
        return DATABASE_VIEW_SEARCHER.getTableViewByTableName(this.databaseView, tableName);
    }
}

