/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.datawriter;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.generalexception.ChangedResourceException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentHasAttributeException;
import ch.nolix.coreapi.datamodel.cardinality.BaseCardinality;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.midschemaview.modelsearcher.TableViewSearcher;
import ch.nolix.system.nodemiddata.nodeeditor.TableNodeEditor;
import ch.nolix.system.nodemiddata.nodeexaminer.TableNodeExaminer;
import ch.nolix.system.nodemiddata.nodemapper.ContentFieldNodeMapper;
import ch.nolix.system.nodemiddata.nodesearcher.EntityNodeSearcher;
import ch.nolix.system.nodemiddata.nodesearcher.TableNodeSearcher;
import ch.nolix.system.nodemiddata.nodevalidator.TableNodeValidator;
import ch.nolix.system.nodemidschema.nodesearcher.DatabaseNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.middata.model.StringRepresentedFieldDto;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.ITableViewSearcher;
import ch.nolix.systemapi.nodemiddata.nodeeditor.ITableNodeEditor;
import ch.nolix.systemapi.nodemiddata.nodeexaminer.ITableNodeExaminer;
import ch.nolix.systemapi.nodemiddata.nodemapper.IContentFieldNodeMapper;
import ch.nolix.systemapi.nodemiddata.nodesearcher.IEntityNodeSearcher;
import ch.nolix.systemapi.nodemiddata.nodesearcher.ITableNodeSearcher;
import ch.nolix.systemapi.nodemiddata.nodevalidator.ITableNodeValidator;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabaseNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.time.moment.ITime;
import java.util.Optional;

public final class DataWriterActionProvider {
    private static final IDatabaseNodeSearcher DATABASE_NODE_SEARCHER = new DatabaseNodeSearcher();
    private static final IDatabasePropertiesNodeSearcher DATABASE_PROPERTIES_NODE_SEARCHER = new DatabasePropertiesNodeSearcher();
    private static final ITableViewSearcher TABLE_VIEW_SEARCHER = new TableViewSearcher();
    private static final ITableNodeSearcher TABLE_NODE_SEARCHER = new TableNodeSearcher();
    private static final ITableNodeExaminer TABLE_NODE_EXAMINER = new TableNodeExaminer();
    private static final ITableNodeValidator TABLE_NODE_VALIDATOR = new TableNodeValidator();
    private static final ITableNodeEditor TABLE_NODE_EDITOR = new TableNodeEditor();
    private static final IEntityNodeSearcher ENTITY_NODE_SEARCHER = new EntityNodeSearcher();
    private static final IContentFieldNodeMapper CONTENT_FIELD_NODE_MAPPER = new ContentFieldNodeMapper();

    private DataWriterActionProvider() {
    }

    public static void clearMultiReference(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiReferencedColumnOneBasedOrdinalIndex) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiReferenceNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiReferencedColumnOneBasedOrdinalIndex);
        multiReferenceNode.reset();
    }

    public static void clearMultiValue(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiValueColumnOneBasedOrdinalIndex) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiValueNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiValueColumnOneBasedOrdinalIndex);
        multiValueNode.reset();
    }

    public static void deleteEntity(IMutableNode<?> database, String tableName, String entityId, String entitySaveStamp) {
        DataWriterActionProvider.deleteEntityIndex(database, entityId);
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(database, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_EDITOR.removeAndGetStoredEntityNodeById(tableNode, entityId);
        IMutableNode<?> saveStampNode = ENTITY_NODE_SEARCHER.getStoredSaveStampNodeFromEntityNode(entityNode);
        if (!saveStampNode.hasHeader(entitySaveStamp)) {
            throw ChangedResourceException.forResource("data");
        }
    }

    public static void deleteMultiBackReferenceEntry(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiBackReferenceColumnOneBasedOrdinalIndex, String backReferencedEntityId) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiBackReferenceColumnNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiBackReferenceColumnOneBasedOrdinalIndex);
        multiBackReferenceColumnNode.removeFirstChildNodeWithHeader(backReferencedEntityId);
    }

    public static void deleteMultiReferenceEntry(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiReferencedColumnOneBasedOrdinalIndex, String referencedEntityId) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiReferenceNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiReferencedColumnOneBasedOrdinalIndex);
        multiReferenceNode.removeFirstChildNodeThat(n -> n.getStoredChildNodeAtOneBasedIndex(1).hasHeader(referencedEntityId));
    }

    public static void deleteMultiValueEntry(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiValueColumnOneBasedOrdinalIndex, String entry) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiValueNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiValueColumnOneBasedOrdinalIndex);
        multiValueNode.removeFirstChildNodeWithHeader(entry);
    }

    public static void expectSchemaTimestamp(IMutableNode<?> nodeDatabase, ITime schemaTimestamp) {
        IMutableNode<?> databasePropertiesNode = DATABASE_NODE_SEARCHER.getStoredDatabasePropertiesNodeFromNodeDatabase(nodeDatabase);
        ITime actualSchemaTimestamp = DATABASE_PROPERTIES_NODE_SEARCHER.getSchemaTimestampFromDatabasePropertiesNode(databasePropertiesNode);
        if (!actualSchemaTimestamp.equals(schemaTimestamp)) {
            throw ChangedResourceException.forResource("schema");
        }
    }

    public static void expectTableContainsEntity(IMutableNode<?> nodeDatabase, String tableName, String entityId) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        TABLE_NODE_VALIDATOR.assertTableNodeContainsEntityWithId(tableNode, entityId);
    }

    public static void insertEntity(IMutableNode<?> nodeDatabase, String tableName, String entityId, INode<?> entityIndexNode, INode<?> entityNode) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        if (TABLE_NODE_EXAMINER.tableNodeContainsEntityNodeWithGivenId(tableNode, entityId)) {
            throw ArgumentHasAttributeException.forArgumentAndAttributeName(tableNode, "entity with the id '" + entityId + "'");
        }
        IMutableNode<?> entityIndexesNode = DATABASE_NODE_SEARCHER.getStoredEntityIndexesNodeFromNodeDatabase(nodeDatabase);
        entityIndexesNode.addChildNode(entityIndexNode, new INode[0]);
        tableNode.addChildNode(entityNode, new INode[0]);
    }

    public static void insertMultiBackReferenceEntry(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiBackReferenceColumnOneBasedOrdinalIndex, INode<?> multiBackReferenceEntryNode) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiBackReferenceNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiBackReferenceColumnOneBasedOrdinalIndex);
        multiBackReferenceNode.addChildNode(multiBackReferenceEntryNode, new INode[0]);
    }

    public static void insertMultiReferenceEntry(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiReferenceColumnOneBasedOrdinalIndex, INode<?> multiReferenceEntryNode) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiReferenceNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiReferenceColumnOneBasedOrdinalIndex);
        multiReferenceNode.addChildNode(multiReferenceEntryNode, new INode[0]);
    }

    public static void insertMultiValueEntry(IMutableNode<?> nodeDatabase, String tableName, String entityId, int multiValueColumnOneBasedOrdinalIndex, String value) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        IMutableNode multiValueNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiValueColumnOneBasedOrdinalIndex);
        Node multiValueValueNode = Node.withHeader(value);
        multiValueNode.addChildNode(multiValueValueNode, new INode[0]);
    }

    public static void updateEntity(IMutableNode<?> database, EntityUpdateDto entityUpdate, TableViewDto tableView) {
        IMutableNode<?> entityNode;
        IMutableNode<?> saveStampNode;
        String actualSaveStamp;
        String entityId;
        String tableName = tableView.name();
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(database, tableName);
        Optional<IMutableNode<?>> entityNodeContainer = TABLE_NODE_SEARCHER.getOptionalStoredEntityNodeFromTableNode(tableNode, entityId = entityUpdate.id());
        if (entityNodeContainer.isEmpty()) {
            throw ChangedResourceException.forResource("data");
        }
        String saveStamp = entityUpdate.saveStamp();
        if (!saveStamp.equals(actualSaveStamp = (saveStampNode = ENTITY_NODE_SEARCHER.getStoredSaveStampNodeFromEntityNode(entityNode = entityNodeContainer.get())).getHeader())) {
            throw ChangedResourceException.forResource("data");
        }
        String newSaveStamp = String.valueOf(Integer.valueOf(saveStamp) + 1);
        saveStampNode.setHeader(newSaveStamp);
        DataWriterActionProvider.updateContentFieldsOfEntityNode(entityNode, entityUpdate, tableView);
    }

    private static void deleteEntityIndex(IMutableNode<?> nodeDatabase, String entityId) {
        IMutableNode<?> entityIndexesNode = DATABASE_NODE_SEARCHER.getStoredEntityIndexesNodeFromNodeDatabase(nodeDatabase);
        entityIndexesNode.removeFirstChildNodeThat(ehn -> ehn.getStoredChildNodeAtOneBasedIndex(2).hasHeader(entityId));
    }

    private static void updateContentFieldsOfEntityNode(IMutableNode<?> entityNode, EntityUpdateDto entityUpdate, TableViewDto tableView) {
        for (StringRepresentedFieldDto f : entityUpdate.updatedContentFields()) {
            String columnName = f.columnName();
            ColumnViewDto columnView = TABLE_VIEW_SEARCHER.getColumnViewByColumnName(tableView, columnName);
            if (columnView.fieldType().getCardinality().getBaseCardinality() != BaseCardinality.SINGLE) continue;
            int oneBasedColumnIndex = columnView.oneBasedOrdinalIndex();
            IMutableNode fieldNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(oneBasedColumnIndex);
            INode<?> newFieldNode = CONTENT_FIELD_NODE_MAPPER.mapStringContentFieldDtoToContentFieldNode(f);
            fieldNode.resetFromNode(newFieldNode);
        }
    }
}

