/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.changesetsaver;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.middatamodelmapper.MultiBackReferenceEntryDeletionDtoMapper;
import ch.nolix.system.objectdata.middatamodelmapper.MultiBackReferenceEntryDtoMapper;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiBackReferenceEntryDeletionDtoMapper;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiBackReferenceEntryDtoMapper;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;

public final class MultiBackReferenceSaver {
    private static final IMultiBackReferenceEntryDtoMapper MULTI_BACK_REFERENCE_ENTRY_DTO_MAPPER = new MultiBackReferenceEntryDtoMapper();
    private static final IMultiBackReferenceEntryDeletionDtoMapper MULTI_BACK_REFERENCE_ENTRY_DELETION_DTO_MAPPER = new MultiBackReferenceEntryDeletionDtoMapper();

    public void saveMultiBackReference(IMultiBackReference<? extends IEntity> multiBackReference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        for (IMultiBackReferenceEntry iMultiBackReferenceEntry : multiBackReference.getStoredNewAndDeletedEntries()) {
            this.saveMultiBackReferenceEntry(iMultiBackReferenceEntry, dataAndSchemaAdapter);
        }
    }

    private void saveMultiBackReferenceEntry(IMultiBackReferenceEntry<?> multiBackReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState multiReferenceEntryState = (DatabaseObjectState)((Object)multiBackReferenceEntry.getState());
        switch (multiReferenceEntryState) {
            case NEW: {
                this.insertMultiBackReferenceEntry(multiBackReferenceEntry, dataAndSchemaAdapter);
                break;
            }
            case UNEDITED: {
                break;
            }
            case DELETED: {
                this.deleteMultiBackReferenceEntry(multiBackReferenceEntry, dataAndSchemaAdapter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName((Object)multiReferenceEntryState, "state of multi reference");
            }
        }
    }

    private void insertMultiBackReferenceEntry(IMultiBackReferenceEntry<?> multiBackReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiBackReferenceEntryDto multiBackReferenceEntryDto = MULTI_BACK_REFERENCE_ENTRY_DTO_MAPPER.mapMultiBackReferenceEntryToMultiBackReferenceEntryDto(multiBackReferenceEntry);
        dataAndSchemaAdapter.insertMultiBackReferenceEntry(multiBackReferenceEntryDto);
    }

    private void deleteMultiBackReferenceEntry(IMultiBackReferenceEntry<?> multiBackReferenceEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiBackReferenceEntryDeletionDto multiBackReferenceEntryDeletionDto = MULTI_BACK_REFERENCE_ENTRY_DELETION_DTO_MAPPER.mapMultiBackReferenceEntryToMultiBackReferenceEntryDeletionDto(multiBackReferenceEntry);
        dataAndSchemaAdapter.deleteMultiBackReferenceEntry(multiBackReferenceEntryDeletionDto);
    }
}

