/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;

public abstract class AbstractBaseBackReference<E extends IEntity>
extends AbstractField
implements IBaseBackReference<E> {
    private final ImmutableList<String> backReferenceableTableNames;
    private final String backReferencedFieldName;
    private Table<E> backReferencedTable;

    protected AbstractBaseBackReference(IContainer<String> backReferenceableTableNames, String backReferencedFieldName) {
        Validator.assertThatTheStrings(backReferenceableTableNames).areNotBlank();
        Validator.assertThat(backReferencedFieldName).thatIsNamed("back referenced field name").isNotBlank();
        this.backReferenceableTableNames = ImmutableList.forIterable(backReferenceableTableNames);
        this.backReferencedFieldName = backReferencedFieldName;
    }

    @Override
    public final IContainer<String> getBackReferenceableTableNames() {
        return this.backReferenceableTableNames;
    }

    @Override
    public final String getBackReferencedFieldName() {
        return this.backReferencedFieldName;
    }

    @Override
    public ITable<E> getStoredBackReferencedTable() {
        this.extractBackReferencedTableIfNotExtracted();
        return this.backReferencedTable;
    }

    @Override
    public final String getBackReferencedTableName() {
        return (String)this.backReferenceableTableNames.getStoredFirst();
    }

    @Override
    public final IContainer<IBaseBackReference<IEntity>> getStoredBaseBackReferencesWhoReferencesBackThis() {
        return ImmutableList.createEmpty();
    }

    @Override
    public final boolean referencesEntity(IEntity entity) {
        return false;
    }

    @Override
    public final boolean referencesUninsertedEntity() {
        return false;
    }

    @Override
    protected final void noteInsertIntoDatabase() {
    }

    private boolean extractedBackReferencedTable() {
        return this.backReferencedTable != null;
    }

    private void extractBackReferencedTable() {
        this.backReferencedTable = this.loadBackReferencedTable();
    }

    private void extractBackReferencedTableIfNotExtracted() {
        if (!this.extractedBackReferencedTable()) {
            this.extractBackReferencedTable();
        }
    }

    private Table<E> loadBackReferencedTable() {
        return (Table)((IDatabase)this.getStoredParentEntity().getStoredParentTable().getStoredParentDatabase()).getStoredTableByName(this.getBackReferencedTableName());
    }
}

