/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;

public abstract class AbstractBaseReference<E extends IEntity>
extends AbstractField
implements IBaseReference {
    private final ImmutableList<String> referenceableTableNames;

    protected AbstractBaseReference(IContainer<String> referenceableTableNames) {
        Validator.assertThatTheStrings(referenceableTableNames).areNotBlank();
        this.referenceableTableNames = ImmutableList.forIterable(referenceableTableNames);
    }

    @Override
    public final IContainer<String> getReferenceableTableNames() {
        return this.referenceableTableNames;
    }

    @Override
    public final IContainer<IBaseReference> getStoredBaseReferencesWhoAreBackReferencedFromThis() {
        return ImmutableList.createEmpty();
    }

    @Override
    public final boolean referencesBackEntity(IEntity entity) {
        return false;
    }

    @Override
    public final boolean referencesBackEntityWithId(String id) {
        return false;
    }

    @Override
    public final boolean referencesBackField(IField field) {
        return false;
    }

    protected final void updateProbableBackReferenceForSetOrAddedEntity(E entity) {
        for (IField iField : entity.internalGetStoredFields()) {
            switch (iField.getType()) {
                case BACK_REFERENCE: {
                    BackReference backReference = (BackReference)iField;
                    if (!backReference.referencesBackField(this)) break;
                    backReference.setBackReferencedEntityOnly(this.getStoredParentEntity());
                    break;
                }
                case OPTIONAL_BACK_REFERENCE: {
                    OptionalBackReference optionalBackReference = (OptionalBackReference)iField;
                    if (!optionalBackReference.referencesBackField(this)) break;
                    optionalBackReference.setBackReferencedEntityOnly(this.getStoredParentEntity());
                }
            }
        }
    }
}

