/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;

public final class Column
implements IColumn {
    private static final String DATA_TYPE_CLASS_VARIABLE = "data type class";
    private final Table<IEntity> parentTable;
    private final String id;
    private final String name;
    private final FieldType fieldType;
    private final Class<Object> dataTypeClass;
    private final ImmutableList<? extends ITable<IEntity>> referenceableTables;
    private final ImmutableList<? extends IColumn> backReferenceableColumns;

    private Column(Table<IEntity> parentTable, String id, String name, FieldType fieldType, Class<Object> dataTypeClass, IContainer<? extends ITable<IEntity>> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(fieldType).thatIsNamed(FieldType.class).isNotNull();
        Validator.assertThat(dataTypeClass).thatIsNamed(DATA_TYPE_CLASS_VARIABLE).isNotNull();
        this.parentTable = parentTable;
        this.id = id;
        this.name = name;
        this.fieldType = fieldType;
        this.dataTypeClass = dataTypeClass;
        this.referenceableTables = ImmutableList.forIterable(referenceableTables);
        this.backReferenceableColumns = ImmutableList.forIterable(backReferenceableColumns);
    }

    static Column withParentTableAndIdAndNameAndFieldTypeAndDataTypeClassAndReferenceableTablesAndBackReferenceableColumns(Table<IEntity> parentTable, String id, String name, FieldType fieldType, Class<Object> dataTypeClass, IContainer<? extends ITable<IEntity>> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        return new Column(parentTable, id, name, fieldType, dataTypeClass, referenceableTables, backReferenceableColumns);
    }

    @Override
    public boolean containsValueInPersistedData(String value) {
        IDataAdapterAndSchemaReader midDataAdapterAndSchemaReader = this.parentTable.getStoredMidDataDataAdapterAndSchemaReader();
        String tableName = this.parentTable.getName();
        String columnName = this.getName();
        return midDataAdapterAndSchemaReader.tableContainsEntityWithValueAtColumn(tableName, columnName, value);
    }

    @Override
    public boolean containsValueInPersistedDataIgnoringEntities(String value, IContainer<String> entitiesToIgnoreIds) {
        IDataAdapterAndSchemaReader midDataAdapterAndSchemaReader = this.parentTable.getStoredMidDataDataAdapterAndSchemaReader();
        String tableName = this.parentTable.getName();
        String columnName = this.getName();
        return midDataAdapterAndSchemaReader.tableContainsEntityWithValueAtColumnIgnoringEntities(tableName, columnName, value, entitiesToIgnoreIds);
    }

    @Override
    public Class<Object> getDataTypeClass() {
        return this.dataTypeClass;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObjectState getState() {
        if (this.getStoredParentTable().isClosed()) {
            return DatabaseObjectState.CLOSED;
        }
        return DatabaseObjectState.UNEDITED;
    }

    @Override
    public IContainer<? extends IColumn> getStoredBackReferenceableColumns() {
        return this.backReferenceableColumns;
    }

    @Override
    public ITable<IEntity> getStoredParentTable() {
        return this.parentTable;
    }

    @Override
    public IContainer<? extends ITable<IEntity>> getStoredReferenceableTables() {
        return this.referenceableTables;
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentTable().isClosed();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentTable().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public boolean isNew() {
        return false;
    }
}

