/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.MultiBackReference;
import ch.nolix.system.objectdata.model.MultiReference;
import ch.nolix.system.objectdata.model.MultiValueField;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.model.OptionalReference;
import ch.nolix.system.objectdata.model.OptionalValueField;
import ch.nolix.system.objectdata.model.Reference;
import ch.nolix.system.objectdata.model.ValueField;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;

public final class FieldMapper {
    private FieldMapper() {
    }

    public static AbstractField mapColumnToField(IColumn column) {
        AbstractField field = FieldMapper.mapColumnToUnlinkedFeild(column);
        field.setParentColumn(column);
        return field;
    }

    private static AbstractField mapColumnToUnlinkedFeild(IColumn column) {
        FieldType fieldType = column.getFieldType();
        return switch (fieldType) {
            case FieldType.VALUE_FIELD -> ValueField.withValueType(column.getDataTypeClass());
            case FieldType.OPTIONAL_VALUE_FIELD -> OptionalValueField.withValueType(column.getDataTypeClass());
            case FieldType.MULTI_VALUE_FIELD -> MultiValueField.withValueType(column.getDataTypeClass());
            case FieldType.REFERENCE -> FieldMapper.createReferenceFromAbstractReferenceModelView(column);
            case FieldType.OPTIONAL_REFERENCE -> FieldMapper.createOptionalReferenceFromAbstractReferenceModelView(column);
            case FieldType.MULTI_REFERENCE -> FieldMapper.createMultiReferenceFromAbstractReferenceModelView(column);
            case FieldType.BACK_REFERENCE -> FieldMapper.createBackReferenceFromAbstractBackReferenceModelView(column);
            case FieldType.OPTIONAL_BACK_REFERENCE -> FieldMapper.createOptionalBackReferenceFromAbstractBackReferenceModelView(column);
            case FieldType.MULTI_BACK_REFERENCE -> FieldMapper.createMultiBackReferenceFromAbstractBackReferenceModelView(column);
            default -> throw new MatchException(null, null);
        };
    }

    private static Reference<AbstractEntity> createReferenceFromAbstractReferenceModelView(IColumn column) {
        IContainer<String> referenceableTableNames = column.getStoredReferenceableTables().to(INameHolder::getName);
        return Reference.forReferenceableTableNames(referenceableTableNames);
    }

    private static OptionalReference<AbstractEntity> createOptionalReferenceFromAbstractReferenceModelView(IColumn column) {
        IContainer<String> referenceableTableNames = column.getStoredReferenceableTables().to(INameHolder::getName);
        return OptionalReference.forReferenceableTableNames(referenceableTableNames);
    }

    private static MultiReference<AbstractEntity> createMultiReferenceFromAbstractReferenceModelView(IColumn column) {
        IContainer<String> referenceableTableNames = column.getStoredReferenceableTables().to(INameHolder::getName);
        return MultiReference.forReferenceableTableNames(referenceableTableNames);
    }

    private static BackReference<AbstractEntity> createBackReferenceFromAbstractBackReferenceModelView(IColumn column) {
        IContainer<? extends IColumn> backReferenceableColumns = column.getStoredBackReferenceableColumns();
        IContainer<ITable<IEntity>> backReferenceableTables = backReferenceableColumns.getViewOf(IColumn::getStoredParentTable);
        String backReferencedFieldName = ((IColumn)backReferenceableColumns.getStoredFirst()).getName();
        return BackReference.forBackReferenceableTablesAndBackReferencedFieldName(backReferenceableTables, backReferencedFieldName);
    }

    private static OptionalBackReference<AbstractEntity> createOptionalBackReferenceFromAbstractBackReferenceModelView(IColumn column) {
        IContainer<? extends IColumn> backReferenceableColumns = column.getStoredBackReferenceableColumns();
        IContainer<ITable<IEntity>> backReferenceableTables = backReferenceableColumns.getViewOf(IColumn::getStoredParentTable);
        String backReferencedFieldName = ((IColumn)backReferenceableColumns.getStoredFirst()).getName();
        return OptionalBackReference.forBackReferenceableTablesAndBackReferencedFieldName(backReferenceableTables, backReferencedFieldName);
    }

    private static MultiBackReference<AbstractEntity> createMultiBackReferenceFromAbstractBackReferenceModelView(IColumn column) {
        IContainer<? extends IColumn> backReferenceableColumns = column.getStoredBackReferenceableColumns();
        IContainer<ITable<IEntity>> backReferenceableTables = backReferenceableColumns.getViewOf(IColumn::getStoredParentTable);
        String backReferencedFieldName = ((IColumn)backReferenceableColumns.getStoredFirst()).getName();
        return MultiBackReference.forBackReferenceableTablesAndBackReferencedFieldName(backReferenceableTables, backReferencedFieldName);
    }
}

