/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.model.AbstractBaseBackReference;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.MultiBackReferenceEntry;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.modelexaminer.IDatabaseObjectExaminer;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;

public final class MultiBackReference<E extends IEntity>
extends AbstractBaseBackReference<E>
implements IMultiBackReference<E> {
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IDatabaseObjectExaminer DATABASE_OBJECT_EXAMINER = new DatabaseObjectExaminer();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private boolean loadedAllPersistedBackReferencedEntityIds;
    private final ILinkedList<MultiBackReferenceEntry<E>> localEntries = LinkedList.createEmpty();

    private MultiBackReference(IContainer<String> backReferenceableTableNames, String backReferencedFieldName) {
        super(backReferenceableTableNames, backReferencedFieldName);
    }

    public static <E2 extends IEntity> MultiBackReference<E2> forBackReferenceableEntityTypesAndBackReferencedFieldName(IContainer<Class<? extends E2>> backReferenceableEntityTypes, String backReferencedFieldName) {
        IContainer<String> backReferenceableTableNames = backReferenceableEntityTypes.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new MultiBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    public static <E2 extends IEntity> MultiBackReference<E2> forBackReferenceableTableNamesAndBackReferencedFieldName(IContainer<String> backReferenceableTableNames, String backReferencedFieldName) {
        return new MultiBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    public static <E2 extends IEntity> MultiBackReference<E2> forBackReferenceableTablesAndBackReferencedFieldName(IContainer<ITable<IEntity>> backReferenceableTables, String backReferencedFieldName) {
        IContainer<String> backReferenceableTableNames = backReferenceableTables.getViewOf(INameHolder::getName);
        return new MultiBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    @Override
    public IContainer<String> getAllBackReferencedEntityIds() {
        this.updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrLoadedOrEdited).to(IMultiBackReferenceEntry::getBackReferencedEntityId);
    }

    @Override
    public IContainer<E> getAllStoredBackReferencedEntities() {
        this.updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrLoadedOrEdited).to(IMultiBackReferenceEntry::getStoredBackReferencedEntity);
    }

    @Override
    public IContainer<? extends IMultiBackReferenceEntry<E>> getStoredNewAndDeletedEntries() {
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrDeleted);
    }

    @Override
    public IContainer<IBaseReference> getStoredBaseReferencesWhoAreBackReferencedFromThis() {
        LinkedList<IBaseReference> abstractReferences = LinkedList.createEmpty();
        String backReferencedBaseReferenceName = this.getBackReferencedFieldName();
        for (IEntity e : this.getAllStoredBackReferencedEntities()) {
            IBaseReference backReferencedField = (IBaseReference)ENTITY_SEARCHER.getStoredFieldByName(e, backReferencedBaseReferenceName);
            abstractReferences.addAtEnd(backReferencedField);
        }
        return abstractReferences;
    }

    @Override
    public FieldType getType() {
        return FieldType.MULTI_BACK_REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
    }

    @Override
    public boolean isEmpty() {
        return this.localEntries.isEmpty() && this.isEmptyWhenDoesNotHaveLocalEntries();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean loadedAllPersistedReferencedEntityIds() {
        return this.loadedAllPersistedBackReferencedEntityIds;
    }

    @Override
    public boolean referencesBackField(IField field) {
        return field != null && field.belongsToEntity() && this.getBackReferencedFieldName().equals(field.getName()) && this.referencesBackEntity((IEntity)field.getStoredParentEntity());
    }

    @Override
    public boolean referencesBackEntity(IEntity entity) {
        String entityId = entity.getId();
        return this.referencesBackEntityWithId(entityId);
    }

    @Override
    public boolean referencesBackEntityWithId(String id) {
        return this.getAllBackReferencedEntityIds().containsEqualing(id);
    }

    void internalAddBackReferencedEntity(IEntity backReferencedEntity) {
        MultiBackReferenceEntry<IEntity> newEntry = MultiBackReferenceEntry.createNewEntryForMultiBackReferenceAndBackReferencedEntity(this, backReferencedEntity);
        this.localEntries.addAtEnd(newEntry);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    void internalDeleteBackReferencedEntityId(String backReferencedEntityId) {
        MultiBackReferenceEntry entry = this.localEntries.getStoredFirst(e -> e.getBackReferencedEntityId().equals(backReferencedEntityId));
        entry.setDeleted();
    }

    private boolean isEmptyWhenDoesNotHaveLocalEntries() {
        return this.getAllStoredBackReferencedEntities().isEmpty();
    }

    private IContainer<MultiBackReferenceEntry<E>> loadAllPersistedBackReferencedEntityIds() {
        AbstractEntity entity = this.getStoredParentEntity();
        return this.getStoredDataAndSchemaAdapter().loadMultiBackReferenceBackReferencedEntityIds(entity.getParentTableName(), entity.getId(), this.getName()).to(e -> MultiBackReferenceEntry.createLoadedEntryForMultiBackReferenceAndBackReferencedEntityIdAndBackReferencedTableId(this, e, "0"));
    }

    private boolean needsToLoadAllPersistedBackReferencedEntityIds() {
        return !this.loadedAllPersistedReferencedEntityIds() && FIELD_EXAMINER.belongsToLoadedEntity(this);
    }

    private void updateStateLoadingAllPersistedBackReferencedEntityIds() {
        this.loadedAllPersistedBackReferencedEntityIds = true;
        this.localEntries.addAtEnd(this.loadAllPersistedBackReferencedEntityIds());
    }

    private void updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded() {
        if (this.needsToLoadAllPersistedBackReferencedEntityIds()) {
            this.updateStateLoadingAllPersistedBackReferencedEntityIds();
        }
    }
}

