/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.systemapi.databaseobject.modelvalidator.IDatabaseObjectValidator;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;
import ch.nolix.systemapi.objectdata.structure.EntityCache;

public final class MultiBackReferenceEntry<E extends IEntity>
implements IMultiBackReferenceEntry<E> {
    private static final IDatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private final IMultiBackReference<E> parentMultiBackReference;
    private DatabaseObjectState state;
    private EntityCache<E> backReferencedEntityCache;

    private MultiBackReferenceEntry(IMultiBackReference<E> parentMultiBackReference, DatabaseObjectState initialState, E backReferencedEntity) {
        Validator.assertThat(parentMultiBackReference).thatIsNamed("parent MultiBackReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(backReferencedEntity).thatIsNamed("back referenced entity").isNotNull();
        String backReferencedEntityId = backReferencedEntity.getId();
        this.parentMultiBackReference = parentMultiBackReference;
        this.state = initialState;
        this.backReferencedEntityCache = new EntityCache<E>(backReferencedEntityId, null, backReferencedEntity);
    }

    private MultiBackReferenceEntry(IMultiBackReference<E> parentMultiBackReference, DatabaseObjectState initialState, String backReferencedEntityId, String backReferencedTableId) {
        Validator.assertThat(parentMultiBackReference).thatIsNamed("parent MultiBackReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(backReferencedEntityId).thatIsNamed("back referenced entity id").isNotBlank();
        Validator.assertThat(backReferencedTableId).thatIsNamed("back referenced table id").isNotBlank();
        this.parentMultiBackReference = parentMultiBackReference;
        this.state = initialState;
        this.backReferencedEntityCache = new EntityCache<Object>(backReferencedEntityId, backReferencedTableId, null);
    }

    public static <E2 extends IEntity> MultiBackReferenceEntry<E2> createLoadedEntryForMultiBackReferenceAndBackReferencedEntityIdAndBackReferencedTableId(IMultiBackReference<E2> multiBackReference, String backReferencedEntityId, String backReferencedTableId) {
        return new MultiBackReferenceEntry<E2>(multiBackReference, DatabaseObjectState.UNEDITED, backReferencedEntityId, backReferencedTableId);
    }

    public static <E2 extends IEntity> MultiBackReferenceEntry<E2> createNewEntryForMultiBackReferenceAndBackReferencedEntityIdAndBackReferencedTableId(IMultiBackReference<E2> multiBackReference, String backReferencedEntityId, String backReferencedTableId) {
        return new MultiBackReferenceEntry<E2>(multiBackReference, DatabaseObjectState.NEW, backReferencedEntityId, backReferencedTableId);
    }

    public static <E2 extends IEntity> MultiBackReferenceEntry<E2> createNewEntryForMultiBackReferenceAndBackReferencedEntity(IMultiBackReference<E2> multiBackReference, E2 backReferencedEntity) {
        return new MultiBackReferenceEntry<E2>(multiBackReference, DatabaseObjectState.NEW, backReferencedEntity);
    }

    @Override
    public String getBackReferencedEntityId() {
        return this.backReferencedEntityCache.entityId();
    }

    @Override
    public DatabaseObjectState getState() {
        return switch ((DatabaseObjectState)((Object)this.getStoredParentMultiBackReference().getState())) {
            case DatabaseObjectState.NEW -> DatabaseObjectState.NEW;
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> this.state;
        };
    }

    @Override
    public E getStoredBackReferencedEntity() {
        return this.getStoredParentMultiBackReference().getStoredBackReferencedTable().getStoredEntityById(this.getBackReferencedEntityId());
    }

    @Override
    public IMultiBackReference<E> getStoredParentMultiBackReference() {
        return this.parentMultiBackReference;
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentMultiBackReference().isClosed();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentMultiBackReference().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isDeleted() {
        return this.getStoredParentMultiBackReference().isDeleted();
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.UNEDITED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    void setDeleted() {
        DATABASE_OBJECT_VALIDATOR.assertIsLoaded(this);
        this.state = DatabaseObjectState.DELETED;
    }
}

