/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.systemapi.databaseobject.modelvalidator.IDatabaseObjectValidator;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectdata.structure.EntityCache;
import java.util.Optional;

final class MultiReferenceEntry<E extends IEntity>
implements IMultiReferenceEntry<E> {
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final IDatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private final IMultiReference<E> parentMultiReference;
    private DatabaseObjectState state;
    private EntityCache<E> referencedEntityCache;

    private MultiReferenceEntry(IMultiReference<E> parentMultiReference, DatabaseObjectState initialState, E referencedEntity) {
        Validator.assertThat(parentMultiReference).thatIsNamed("parent MultiReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(referencedEntity).thatIsNamed("referenced entity").isNotNull();
        String referencedEntityId = referencedEntity.getId();
        this.parentMultiReference = parentMultiReference;
        this.state = initialState;
        this.referencedEntityCache = new EntityCache<E>(referencedEntityId, null, referencedEntity);
    }

    private MultiReferenceEntry(IMultiReference<E> parentMultiReference, DatabaseObjectState initialState, String referencedEntityId, String referencedTableId) {
        Validator.assertThat(parentMultiReference).thatIsNamed("parent MultiReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(referencedEntityId).thatIsNamed("referenced entity id").isNotBlank();
        Validator.assertThat(referencedTableId).thatIsNamed("referenced table id").isNotBlank();
        this.parentMultiReference = parentMultiReference;
        this.state = initialState;
        this.referencedEntityCache = new EntityCache<Object>(referencedEntityId, referencedTableId, null);
    }

    public static <E2 extends IEntity> MultiReferenceEntry<E2> createLoadedEntryForMultiReferenceAndReferencedEntityIdAndReferencedTableId(IMultiReference<E2> multiReference, String referencedEntityId, String referencedTableId) {
        return new MultiReferenceEntry<E2>(multiReference, DatabaseObjectState.UNEDITED, referencedEntityId, referencedTableId);
    }

    public static <E2 extends IEntity> MultiReferenceEntry<E2> createNewEntryForMultiReferenceAndReferencedEntity(IMultiReference<E2> multiReference, E2 referencedEntity) {
        return new MultiReferenceEntry<E2>(multiReference, DatabaseObjectState.NEW, referencedEntity);
    }

    public static <E2 extends IEntity> MultiReferenceEntry<E2> createNewEntryForMultiReferenceAndReferencedEntityIdAndReferencedTableId(IMultiReference<E2> multiReference, String referencedEntityId, String referencedTableId) {
        return new MultiReferenceEntry<E2>(multiReference, DatabaseObjectState.NEW, referencedEntityId, referencedTableId);
    }

    @Override
    public boolean belongsToDatabase() {
        return this.getStoredParentMultiReference().belongsToDatabase();
    }

    @Override
    public boolean belongsToTable() {
        return this.getStoredParentMultiReference().belongsToTable();
    }

    @Override
    public Optional<? extends IField> getOptionalStoredBaseBackReferenceWhoReferencesBackTheParentMultiReferenceOfThis() {
        return this.getStoredReferencedEntity().internalGetStoredFields().getOptionalStoredFirst(p -> p.referencesBackField(this.getStoredParentMultiReference()));
    }

    @Override
    public String getReferencedEntityId() {
        return this.referencedEntityCache.entityId();
    }

    @Override
    public String getReferencedTableId() {
        this.retrieveReferencedTableId();
        return this.referencedEntityCache.nullableTableId();
    }

    @Override
    public String getReferencedTableName() {
        IEntity referencedEntity = (IEntity)this.referencedEntityCache.nullableEntity();
        if (referencedEntity != null) {
            return referencedEntity.getParentTableName();
        }
        return this.getStoredReferencedTable().getName();
    }

    @Override
    public DatabaseObjectState getState() {
        this.updateStateFromParentMultiReference();
        return this.state;
    }

    @Override
    public IDatabase getStoredParentDatabase() {
        return (IDatabase)this.getStoredParentTable().getStoredParentDatabase();
    }

    @Override
    public IMultiReference<E> getStoredParentMultiReference() {
        return this.parentMultiReference;
    }

    @Override
    public ITable<? extends IEntity> getStoredParentTable() {
        return (ITable)this.getStoredParentMultiReference().getStoredParentTable();
    }

    @Override
    public E getStoredReferencedEntity() {
        this.retrieveReferencedEntity();
        return (E)((IEntity)this.referencedEntityCache.nullableEntity());
    }

    @Override
    public ITable<E> getStoredReferencedTable() {
        IEntity referencedEntity = (IEntity)this.referencedEntityCache.nullableEntity();
        if (referencedEntity != null && referencedEntity.belongsToTable()) {
            return (ITable)referencedEntity.getStoredParentTable();
        }
        if (this.belongsToDatabase()) {
            IDatabase database = (IDatabase)this.parentMultiReference.getStoredParentDatabase();
            return DATABASE_SEARCHER.getStoredTableById(database, this.getReferencedTableId());
        }
        IDatabase database = (IDatabase)((IEntity)this.referencedEntityCache.nullableEntity()).getStoredParentDatabase();
        return DATABASE_SEARCHER.getStoredTableById(database, this.getReferencedTableId());
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentMultiReference().isClosed();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentMultiReference().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isDeleted() {
        return this.getStoredParentMultiReference().isDeleted();
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.UNEDITED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    void setDeleted() {
        DATABASE_OBJECT_VALIDATOR.assertIsLoaded(this);
        this.state = DatabaseObjectState.DELETED;
    }

    private void retrieveReferencedEntity() {
        IEntity referencedEntity = (IEntity)this.referencedEntityCache.nullableEntity();
        if (referencedEntity == null) {
            String referencedEntityId = this.referencedEntityCache.entityId();
            String referencedTableId = this.referencedEntityCache.nullableTableId();
            referencedEntity = this.getStoredReferencedTable().getStoredEntityById(referencedEntityId);
            this.referencedEntityCache = new EntityCache<IEntity>(referencedEntityId, referencedTableId, referencedEntity);
        }
    }

    private void retrieveReferencedTableId() {
        String referencedTableId = this.referencedEntityCache.nullableTableId();
        if (referencedTableId == null) {
            String referencedEntityId = this.referencedEntityCache.entityId();
            IEntity referencedEntity = (IEntity)this.referencedEntityCache.nullableEntity();
            referencedTableId = ((ITable)referencedEntity.getStoredParentTable()).getId();
            this.referencedEntityCache = new EntityCache<IEntity>(referencedEntityId, referencedTableId, referencedEntity);
        }
    }

    private void updateStateFromParentMultiReference() {
        this.state = switch ((DatabaseObjectState)((Object)this.getStoredParentMultiReference().getState())) {
            case DatabaseObjectState.NEW -> DatabaseObjectState.NEW;
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> this.state;
        };
    }
}

