/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldvalidator.FieldValidator;
import ch.nolix.system.objectdata.model.AbstractBaseBackReference;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldvalidator.IFieldValidator;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IOptionalBackReference;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import ch.nolix.systemapi.objectdata.structure.EntityCache;

public final class OptionalBackReference<E extends IEntity>
extends AbstractBaseBackReference<E>
implements IOptionalBackReference<E> {
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldValidator FIELD_VALIDATOR = new FieldValidator();
    private EntityCache<E> nullableBackReferencedEntityCache;

    private OptionalBackReference(IContainer<String> backReferenceableTableNamese, String backReferencedFieldName) {
        super(backReferenceableTableNamese, backReferencedFieldName);
    }

    public static <E2 extends IEntity> OptionalBackReference<E2> forBackReferenceableEntityTypesAndBackReferencedFieldName(IContainer<Class<? extends E2>> backReferenceableEntityTypes, String backReferencedFieldName) {
        IContainer<String> backReferenceableTableNames = backReferenceableEntityTypes.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new OptionalBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    public static <E2 extends IEntity> OptionalBackReference<E2> forBackReferenceableTableNamesAndBackReferencedFieldName(IContainer<String> backReferenceableTableNames, String backReferencedFieldName) {
        return new OptionalBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    public static <E2 extends IEntity> OptionalBackReference<E2> forBackReferenceableTablesAndBackReferencedFieldName(IContainer<ITable<IEntity>> backReferenceableTables, String backReferencedFieldName) {
        IContainer<String> backReferenceableTableNames = backReferenceableTables.getViewOf(INameHolder::getName);
        return new OptionalBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    @Override
    public String getBackReferencedEntityId() {
        FIELD_VALIDATOR.assertIsNotEmpty(this);
        return this.nullableBackReferencedEntityCache.entityId();
    }

    @Override
    public String getBackReferencedTableId() {
        this.retrieveBackReferencedTableId();
        return this.nullableBackReferencedEntityCache.nullableTableId();
    }

    @Override
    public E getStoredBackReferencedEntity() {
        return this.getStoredBackReferencedTable().getStoredEntityById(this.getBackReferencedEntityId());
    }

    @Override
    public ITable<E> getStoredBackReferencedTable() {
        IEntity backReferencedEntity = (IEntity)this.nullableBackReferencedEntityCache.nullableEntity();
        if (backReferencedEntity != null && backReferencedEntity.belongsToTable()) {
            return (ITable)backReferencedEntity.getStoredParentTable();
        }
        if (this.belongsToDatabase()) {
            return DATABASE_SEARCHER.getStoredTableById(this.getStoredParentDatabase(), this.getBackReferencedTableId());
        }
        IDatabase database = (IDatabase)((IEntity)this.nullableBackReferencedEntityCache.nullableEntity()).getStoredParentDatabase();
        return DATABASE_SEARCHER.getStoredTableById(database, this.getBackReferencedTableId());
    }

    @Override
    public IContainer<IBaseReference> getStoredBaseReferencesWhoAreBackReferencedFromThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IBaseReference backReferencedField = (IBaseReference)ENTITY_SEARCHER.getStoredFieldByName((IEntity)this.getStoredBackReferencedEntity(), this.getBackReferencedFieldName());
        return ImmutableList.withElement(backReferencedField, new IBaseReference[0]);
    }

    @Override
    public FieldType getType() {
        return FieldType.OPTIONAL_BACK_REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        String id = (String)nullableValue;
        if (id == null) {
            this.nullableBackReferencedEntityCache = null;
        } else {
            String tableId = nullableAdditionalValue;
            if (tableId == null) {
                throw ArgumentIsNullException.forArgumentName("table id");
            }
            this.nullableBackReferencedEntityCache = new EntityCache<Object>(id, tableId, null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nullableBackReferencedEntityCache == null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean referencesBackEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getBackReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesBackEntityWithId(String id) {
        return this.containsAny() && this.getBackReferencedEntityId().equals(id);
    }

    @Override
    public boolean referencesBackField(IField field) {
        return field != null && field.belongsToEntity() && this.containsAny() && this.getBackReferencedTableName().equals(((IEntity)field.getStoredParentEntity()).getParentTableName()) && this.getBackReferencedFieldName().equals(field.getName()) && this.getBackReferencedEntityId().equals(((IEntity)field.getStoredParentEntity()).getId());
    }

    void clear() {
        this.nullableBackReferencedEntityCache = null;
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    void setBackReferencedEntityOnly(IEntity entity) {
        String entityId = entity.getId();
        IEntity castedEntity = entity;
        if (entity.belongsToTable()) {
            ITable table = (ITable)entity.getStoredParentTable();
            String tableId = table.getId();
            this.nullableBackReferencedEntityCache = new EntityCache<IEntity>(entityId, tableId, castedEntity);
        } else {
            this.nullableBackReferencedEntityCache = new EntityCache<IEntity>(entityId, null, castedEntity);
        }
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void retrieveBackReferencedTableId() {
        FIELD_VALIDATOR.assertIsNotEmpty(this);
        String backReferencedTableId = this.nullableBackReferencedEntityCache.nullableTableId();
        if (backReferencedTableId == null) {
            String backReferencedEntityId = this.nullableBackReferencedEntityCache.entityId();
            IEntity backReferencedEntity = (IEntity)this.nullableBackReferencedEntityCache.nullableEntity();
            ITable backReferencedTable = (ITable)backReferencedEntity.getStoredParentTable();
            backReferencedTableId = backReferencedTable.getId();
            this.nullableBackReferencedEntityCache = new EntityCache<IEntity>(backReferencedEntityId, backReferencedTableId, backReferencedEntity);
        }
    }
}

