/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldtool.OptionalReferenceTool;
import ch.nolix.system.objectdata.fieldvalidator.OptionalReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractBaseReference;
import ch.nolix.system.objectdata.model.BaseBackReferenceUpdater;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldtool.IOptionalReferenceTool;
import ch.nolix.systemapi.objectdata.fieldvalidator.IOptionalReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import ch.nolix.systemapi.objectdata.structure.EntityCache;
import java.util.Optional;

public final class OptionalReference<E extends IEntity>
extends AbstractBaseReference<E>
implements IOptionalReference<E> {
    private static final IDatabaseSearcher DATABASE_SEARCHER = new DatabaseSearcher();
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IOptionalReferenceValidator OPTIONAL_REFERENCE_VALIDATOR = new OptionalReferenceValidator();
    private static final IOptionalReferenceTool OPTIONAL_REFERENCE_TOOL = new OptionalReferenceTool();
    private EntityCache<E> nullableReferencedEntityCache;

    private OptionalReference(IContainer<String> referenceableTableNames) {
        super(referenceableTableNames);
    }

    @SafeVarargs
    public static <E2 extends IEntity> OptionalReference<E2> forEntityType(Class<? extends E2> entity, Class<? extends E2> ... entityTypes) {
        ContainerView<Class<String>> allEntityTypes = ContainerView.forElementAndArray(entity, entityTypes);
        IContainer<String> referenceableTableNames = allEntityTypes.to(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new OptionalReference(referenceableTableNames);
    }

    public static <E2 extends IEntity> OptionalReference<E2> forReferenceableTableName(String referenceableTableName, String ... referenceableTableNames) {
        ContainerView<String> allReferenceableTableNames = ContainerView.forElementAndArray(referenceableTableName, referenceableTableNames);
        return new OptionalReference(allReferenceableTableNames);
    }

    public static <E2 extends IEntity> OptionalReference<E2> forReferenceableTableNames(IContainer<String> referenceableTableNames) {
        return new OptionalReference(referenceableTableNames);
    }

    @Override
    public void clear() {
        if (this.containsAny()) {
            this.clearWhenContainsAny();
        }
    }

    @Override
    public String getReferencedEntityId() {
        OPTIONAL_REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        return this.nullableReferencedEntityCache.entityId();
    }

    @Override
    public String getReferencedTableId() {
        this.retrieveReferencedTableId();
        return this.nullableReferencedEntityCache.nullableTableId();
    }

    @Override
    public String getReferencedTableName() {
        OPTIONAL_REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
        if (referencedEntity != null) {
            return referencedEntity.getParentTableName();
        }
        return this.getStoredReferencedTable().getName();
    }

    @Override
    public IContainer<IBaseBackReference<IEntity>> getStoredBaseBackReferencesWhoReferencesBackThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = this.getStoredReferencedEntity().internalGetStoredFields();
        Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
        if (abstractBackReferenceContainer.isPresent()) {
            IBaseBackReference abstractBackReference = (IBaseBackReference)abstractBackReferenceContainer.get();
            return ImmutableList.withElement(abstractBackReference, new IBaseBackReference[0]);
        }
        return ImmutableList.createEmpty();
    }

    @Override
    public E getStoredReferencedEntity() {
        this.retrieveReferencedEntity();
        return (E)((IEntity)this.nullableReferencedEntityCache.nullableEntity());
    }

    @Override
    public ITable<E> getStoredReferencedTable() {
        IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
        if (referencedEntity != null && referencedEntity.belongsToTable()) {
            return (ITable)referencedEntity.getStoredParentTable();
        }
        if (this.belongsToDatabase()) {
            return DATABASE_SEARCHER.getStoredTableById(this.getStoredParentDatabase(), this.getReferencedTableId());
        }
        IDatabase database = (IDatabase)((IEntity)this.nullableReferencedEntityCache.nullableEntity()).getStoredParentDatabase();
        return DATABASE_SEARCHER.getStoredTableById(database, this.getReferencedTableId());
    }

    @Override
    public FieldType getType() {
        return FieldType.OPTIONAL_REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        String id = (String)nullableValue;
        if (id == null) {
            this.nullableReferencedEntityCache = null;
        } else {
            String tableId = nullableAdditionalValue;
            if (tableId == null) {
                throw ArgumentIsNullException.forArgumentName("table id");
            }
            this.nullableReferencedEntityCache = new EntityCache<Object>(id, tableId, null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nullableReferencedEntityCache == null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.containsAny() && !this.getStoredReferencedEntity().belongsToTable();
    }

    @Override
    public void setEntity(Object entity) {
        this.setCastedEntity((IEntity)entity);
    }

    @Override
    public void setEntityById(String id) {
        E entity = this.getStoredReferencedTable().getStoredEntityById(id);
        this.setEntity(entity);
    }

    @Override
    protected void noteInsertIntoDatabase() {
        if (this.containsAny()) {
            this.updateProbableBackReferenceForSetOrAddedEntity(this.getStoredReferencedEntity());
        }
    }

    private void assertCanBeCleared() {
        OPTIONAL_REFERENCE_VALIDATOR.assertCanBeCleared(this);
    }

    private void assertCanSetEntity(E entity) {
        OPTIONAL_REFERENCE_VALIDATOR.assertCanSetEntity(this, entity);
    }

    private void clearWhenContainsAny() {
        this.assertCanBeCleared();
        this.updateProbableBackReferencingFieldForClear();
        this.updateStateForClear();
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private Optional<? extends IField> getOptionalPendantReferencingFieldToEntity(E entity) {
        return ENTITY_SEARCHER.getStoredFieldsWhoAreBackReferencedFromEntity((IEntity)entity).getOptionalStoredFirst(f -> f.hasName(this.getName()));
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private void retrieveReferencedEntity() {
        OPTIONAL_REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
        if (referencedEntity == null) {
            String referencedEntityId = this.nullableReferencedEntityCache.entityId();
            String referencedTableId = this.nullableReferencedEntityCache.nullableTableId();
            referencedEntity = this.getStoredReferencedTable().getStoredEntityById(referencedEntityId);
            this.nullableReferencedEntityCache = new EntityCache<IEntity>(referencedEntityId, referencedTableId, referencedEntity);
        }
    }

    private void retrieveReferencedTableId() {
        OPTIONAL_REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        String referencedTableId = this.nullableReferencedEntityCache.nullableTableId();
        if (referencedTableId == null) {
            String referencedEntityId = this.nullableReferencedEntityCache.entityId();
            IEntity referencedEntity = (IEntity)this.nullableReferencedEntityCache.nullableEntity();
            ITable referencedTable = (ITable)referencedEntity.getStoredParentTable();
            referencedTableId = referencedTable.getId();
            this.nullableReferencedEntityCache = new EntityCache<IEntity>(referencedEntityId, referencedTableId, referencedEntity);
        }
    }

    private void setCastedEntity(E entity) {
        this.assertCanSetEntity(entity);
        this.updatePropbableBackReferencingFieldOfEntityForClear(entity);
        this.clear();
        this.updateStateForSetEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForSetEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updatePotentialBaseBackReferenceOfEntityForSetEntity(E entity) {
        BaseReferenceUpdater.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateProbableBackReferencingFieldForClear() {
        if (this.containsAny()) {
            this.updateProbableBackReferencingFieldForClearWhenIsNotEmpty();
        }
    }

    private void updateProbableBackReferencingFieldForClearWhenIsNotEmpty() {
        Optional<IBaseBackReference<IEntity>> backReferencingField = OPTIONAL_REFERENCE_TOOL.getOptionalStoredBaseBackReference(this);
        if (backReferencingField.isPresent()) {
            BaseBackReferenceUpdater.updateBaseBackReferenceForClearBaseReference(backReferencingField.get());
        }
    }

    private void updatePropbableBackReferencingFieldOfEntityForClear(E entity) {
        Optional<IField> pendantReferencingField = this.getOptionalPendantReferencingFieldToEntity(entity);
        if (pendantReferencingField.isPresent()) {
            OptionalReference reference = (OptionalReference)pendantReferencingField.get();
            reference.clear();
        }
    }

    private void updateStateForSetEntity(E entity) {
        String id = entity.getId();
        this.nullableReferencedEntityCache = new EntityCache<E>(id, null, entity);
    }

    private void updateStateForClear() {
        this.nullableReferencedEntityCache = null;
    }
}

