/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelsearcher;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.attribute.mandatoryattribute.IIdHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.modelexaminer.ColumnExaminer;
import ch.nolix.systemapi.databaseobject.request.DeletionRequestable;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelexaminer.IColumnExaminer;
import ch.nolix.systemapi.objectdata.modelsearcher.ITableSearcher;

public final class TableSearcher
extends DatabaseObjectExaminer
implements ITableSearcher {
    private static final IColumnExaminer COLUMN_EXAMINER = new ColumnExaminer();

    @Override
    public IContainer<String> getLocallyDeletedEntityIds(ITable<?> table) {
        if (table == null) {
            return ImmutableList.createEmpty();
        }
        return table.internalGetStoredEntitiesInLocalData().getStoredSelected(DeletionRequestable::isDeleted).to(IIdHolder::getId);
    }

    @Override
    public <E extends IEntity> IContainer<IColumn> getStoredColumsThatReferencesTable(ITable<E> table) {
        if (table == null) {
            return ImmutableList.createEmpty();
        }
        LinkedList<IColumn> columnViews = LinkedList.createEmpty();
        for (ITable iTable : ((IDatabase)table.getStoredParentDatabase()).getStoredTables()) {
            for (IColumn c : iTable.getStoredColumns()) {
                if (!COLUMN_EXAMINER.containsReferenceableTable(c, iTable)) continue;
                columnViews.addAtEnd(c);
            }
        }
        return columnViews;
    }
}

