/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.system.objectschema.model.AbstractSchemaObject;
import ch.nolix.system.objectschema.model.DatabaseMutationExecutor;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.system.objectschema.model.TableLoader;
import ch.nolix.system.objectschema.modelvalidator.DatabaseValidator;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelvalidator.IDatabaseValidator;

public final class Database
extends AbstractSchemaObject
implements IDatabase {
    private static final DatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private static final IDatabaseValidator DATABASE_VALIDATOR = new DatabaseValidator();
    private final String name;
    private boolean loadedTablesFromDatabase;
    private final ISchemaAdapter midSchemaAdapter;
    private LinkedList<ITable> tables = LinkedList.createEmpty();

    public Database(String name, ISchemaAdapter midSchemaAdapter) {
        DATABASE_VALIDATOR.assertCanSetGivenNameToDatabase(name);
        Validator.assertThat(midSchemaAdapter).thatIsNamed("mid schema adapter").isNotNull();
        this.name = name;
        this.midSchemaAdapter = midSchemaAdapter;
        this.setLoaded();
    }

    @Override
    public Database addTable(ITable table) {
        DATABASE_VALIDATOR.assertCanAddGivenTable(this, table);
        DatabaseMutationExecutor.addTableToDatabase(this, (Table)table);
        return this;
    }

    @Override
    public Database createTableWithName(String name) {
        Table table = Table.withName(name);
        return this.addTable(table);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IContainer<ITable> getStoredTables() {
        this.loadTablesFromDatabaseIfNeeded();
        return this.tables;
    }

    @Override
    public int getTableCount() {
        if (!this.isConnectedWithRealDatabase() || this.hasLoadedTablesFromDatabase()) {
            return this.tables.getCount();
        }
        return this.midSchemaAdapter.getTableCount();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.midSchemaAdapter != null;
    }

    @Override
    protected void noteClose() {
        for (ITable t : this.tables) {
            ((Table)t).close();
        }
    }

    void addTableAttribute(ITable table) {
        this.tables.addAtEnd(table);
    }

    ISchemaAdapter getStoredMidSchemaAdapter() {
        DATABASE_OBJECT_VALIDATOR.assertIsConnectedWithRealDatabase(this);
        return this.midSchemaAdapter;
    }

    void removeTableAttribute(Table table) {
        this.tables.removeStrictlyFirstOccurrenceOf(table);
    }

    private boolean hasLoadedTablesFromDatabase() {
        return this.loadedTablesFromDatabase;
    }

    private void loadTablesFromDatabase() {
        IContainer<Table> loadedTables = TableLoader.loadTables(this.getStoredMidSchemaAdapter());
        for (Table t : loadedTables) {
            t.setParentDatabase(this);
            this.tables.addAtEnd(t);
        }
        this.loadedTablesFromDatabase = true;
    }

    private void loadTablesFromDatabaseIfNeeded() {
        if (this.needsToLoadTablesFromDatabase()) {
            this.loadTablesFromDatabase();
        }
    }

    private boolean needsToLoadTablesFromDatabase() {
        return this.isLoaded() && !this.hasLoadedTablesFromDatabase();
    }
}

