/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modelmutationvalidator;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectschema.modelmutationexaminer.ColumnMutationExaminer;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelmutationexaminer.IColumnMutationExaminer;
import ch.nolix.systemapi.objectschema.modelmutationvalidator.IColumnMutationValidator;

public final class ColumnMutationValidator
implements IColumnMutationValidator {
    private static final IColumnMutationExaminer COLUMN_MUTATION_EXAMINER = new ColumnMutationExaminer();

    @Override
    public void assertCanBeDeleted(IColumn column) {
        if (!COLUMN_MUTATION_EXAMINER.canBeDeleted(column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "cannot be deleted");
        }
    }

    @Override
    public void assertCanSetName(IColumn column, String name) {
        if (!COLUMN_MUTATION_EXAMINER.canSetName(column, name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "cannot set the name '" + name + "'");
        }
    }

    @Override
    public void assertCanSetContentModel(IColumn column, FieldType fieldType, DataType dataType, IContainer<? extends ITable> referenceableTables, IContainer<? extends IColumn> backReferenceableColumns) {
        boolean canSetContentModel = COLUMN_MUTATION_EXAMINER.canSetContentModel(column, fieldType, dataType, referenceableTables, backReferenceableColumns);
        if (!canSetContentModel) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "cannot set the given content model'");
        }
    }
}

