/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmiddata.modelmapper;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import ch.nolix.system.sqlmiddata.modelmapper.ContentFieldDtoMapper;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.middata.model.FieldDto;
import ch.nolix.systemapi.midschema.databasestructure.FixDatabasePropertyCatalogue;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.sqlmiddata.modelmapper.IContentFieldDtoMapper;
import ch.nolix.systemapi.sqlmiddata.modelmapper.ILoadedEntityDtoMapper;
import java.util.Iterator;

public final class LoadedEntityDtoMapper
implements ILoadedEntityDtoMapper {
    private static final IContentFieldDtoMapper CONTENT_FIELD_DTO_MAPPER = new ContentFieldDtoMapper();

    @Override
    public EntityLoadingDto mapSqlRecordToEntityLoadingDto(ISqlRecord sqlRecord, TableViewDto tableView) {
        return new EntityLoadingDto((String)sqlRecord.getStoredAtOneBasedIndex(1), (String)sqlRecord.getStoredAtOneBasedIndex(2), this.mapSqlRecordToContentFieldDtos(sqlRecord, tableView.columnViews()));
    }

    @Override
    public IContainer<FieldDto> mapSqlRecordToContentFieldDtos(ISqlRecord sqlRecord, IContainer<ColumnViewDto> columnViews) {
        LinkedList<FieldDto> contentFieldDtos = LinkedList.createEmpty();
        Iterator sqlRecordValueIterator = sqlRecord.iterator();
        FlowController.forCount(FixDatabasePropertyCatalogue.NUMBER_OF_ENTITY_META_FIELDS).run(((CopyableIterator)sqlRecordValueIterator)::next);
        String previousString = null;
        for (ColumnViewDto c : columnViews) {
            if (previousString == null) {
                FieldType fieldType = c.fieldType();
                if (fieldType == FieldType.REFERENCE || fieldType == FieldType.OPTIONAL_REFERENCE || fieldType == FieldType.BACK_REFERENCE || fieldType == FieldType.OPTIONAL_BACK_REFERENCE) {
                    previousString = (String)sqlRecordValueIterator.next();
                    continue;
                }
                String string = (String)sqlRecordValueIterator.next();
                FieldDto contentFieldDto = CONTENT_FIELD_DTO_MAPPER.mapNullableStringRepresentedValueToContentFieldDto(string, null, c);
                contentFieldDtos.addAtEnd(contentFieldDto);
                continue;
            }
            String string = (String)sqlRecordValueIterator.next();
            FieldDto contentFieldDto = CONTENT_FIELD_DTO_MAPPER.mapNullableStringRepresentedValueToContentFieldDto(string, previousString, c);
            contentFieldDtos.addAtEnd(contentFieldDto);
            previousString = null;
        }
        return contentFieldDtos;
    }
}

