/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.databaseinitializer;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.midschema.databaseinitializer.AbstractDatabaseInitializer;
import ch.nolix.system.sqlmidschema.databaseinitializer.DatabaseInitializerTool;
import ch.nolix.system.sqlmidschema.databaseinitializer.DatabaseStateAnalyser;
import ch.nolix.system.sqlschema.adapter.SchemaWriter;
import ch.nolix.systemapi.midschema.databaseinitializer.DatabaseState;
import ch.nolix.systemapi.sqlmidschema.databaseinitializer.IDatabaseInitializerTool;
import ch.nolix.systemapi.sqlmidschema.databaseinitializer.IDatabaseStateAnalyser;
import ch.nolix.systemapi.time.moment.ITime;

public final class DatabaseInitializer
extends AbstractDatabaseInitializer {
    private static final IDatabaseStateAnalyser DATABASE_STATE_ANALYSER = new DatabaseStateAnalyser();
    private static final IDatabaseInitializerTool DATABASE_INITIALIZER_TOOL = new DatabaseInitializerTool();
    private final String databaseName;
    private final ISqlConnection sqlConnection;

    private DatabaseInitializer(String databaseName, ISqlConnection sqlConnection) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        ResourceValidator.assertIsOpen(sqlConnection);
        this.databaseName = databaseName;
        this.sqlConnection = sqlConnection;
    }

    public static DatabaseInitializer forDatabaseNameAndSqlConnection(String databaseName, ISqlConnection sqlConnection) {
        return new DatabaseInitializer(databaseName, sqlConnection);
    }

    @Override
    public DatabaseState getDatabaseState() {
        return DATABASE_STATE_ANALYSER.getDatabasState(this.databaseName, this.sqlConnection);
    }

    @Override
    protected void initializeDatabaseWithInitialSchemaTimestamp(ITime initialSchemaTimestamp) {
        SchemaWriter schemaWriter = SchemaWriter.forDatabasNameAndSqlConnection(this.databaseName, this.sqlConnection);
        DATABASE_INITIALIZER_TOOL.initializeFixTables(schemaWriter);
        DATABASE_INITIALIZER_TOOL.saveSchemaTimestamp(initialSchemaTimestamp, this.sqlConnection, this.databaseName);
    }
}

