/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.schemareader;

import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import ch.nolix.system.sqlmidschema.modelmapper.TableDtoMapper;
import ch.nolix.system.sqlmidschema.querycreator.QueryCreator;
import ch.nolix.system.time.moment.Time;
import ch.nolix.systemapi.midschema.adapter.ISchemaReader;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.sqlmidschema.modelmapper.ITableDtoMapper;
import ch.nolix.systemapi.sqlmidschema.querycreator.IQueryCreator;

public final class SchemaReader
implements ISchemaReader {
    private static final IQueryCreator QUERY_CREATOR = new QueryCreator();
    private static final ITableDtoMapper TABLE_DTO_MAPPER = new TableDtoMapper();
    private final ICloseController closeController = CloseController.forElement(this);
    private final ISqlConnection sqlConnection;
    private final ch.nolix.systemapi.sqlschema.adapter.ISchemaReader sqlSchemaReader;

    private SchemaReader(String databaseName, ISqlConnection sqlConnection) {
        this.sqlSchemaReader = ch.nolix.system.sqlschema.adapter.SchemaReader.forDatabaseNameAndSqlConnection(databaseName, sqlConnection);
        this.sqlConnection = sqlConnection;
    }

    public static SchemaReader forDatabaseNameAndSqlConnection(String databaseName, ISqlConnection sqlConnection) {
        return new SchemaReader(databaseName, sqlConnection);
    }

    @Override
    public boolean columnIsEmpty(String tableName, String columnName) {
        return this.sqlSchemaReader.columnIsEmpty(tableName, columnName);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getTableCount() {
        String query = QUERY_CREATOR.createQueryToGetTableCount();
        ISqlRecord sqlRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        String value = (String)sqlRecord.getStoredOne();
        return Integer.valueOf(value);
    }

    @Override
    public Time getSchemaTimestamp() {
        String query = QUERY_CREATOR.createQueryToLoadSchemaTimestamp();
        ISqlRecord sqlRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        String value = (String)sqlRecord.getStoredOne();
        return Time.fromString(value);
    }

    @Override
    public TableDto loadTable(String tableName) {
        String query = QUERY_CREATOR.createQueryToLoadJoinedColumns(tableName);
        IContainer<ISqlRecord> sqlRecords = this.sqlConnection.getRecordsFromQuery(query);
        return TABLE_DTO_MAPPER.mapJoinedColumnSqlRecordsToTableDto(sqlRecords);
    }

    @Override
    public IContainer<TableDto> loadTables() {
        String query = QUERY_CREATOR.createQueryToLoadJoinedColumns();
        IContainer<ISqlRecord> sqlRecords = this.sqlConnection.getRecordsFromQuery(query);
        return TABLE_DTO_MAPPER.mapJoinedColumnSqlRecordsToTableDtos(sqlRecords);
    }

    @Override
    public void noteClose() {
    }
}

