/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AbstractStyle;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.stylable.IStylableElement;

public abstract class AbstractSelectingStyle
extends AbstractStyle<ISelectingStyleWithSelectors>
implements ISelectingStyleWithSelectors {
    protected static final String SELECTOR_ID_HEADER = "SelectorId";
    protected static final String SELECTOR_TYPE_HEADER = "SelectorType";
    protected static final String SELECTOR_ROLE_HEADER = "SelectorRole";
    protected static final String SELECTOR_TOKEN_HEADER = "SelectorToken";
    private final String selectorId;
    private final String selectorType;
    private final ImmutableList<String> selectorRoles;
    private final ImmutableList<String> selectorTokens;

    protected AbstractSelectingStyle(String optionalSelectorId, String optionalSelectorType, IContainer<String> selectorRoles, IContainer<String> selectorTokens, IContainer<? extends IAttachingAttribute> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        super(attachingAttributes, subStyles);
        Validator.assertThatTheStrings(selectorRoles).areNotBlank();
        Validator.assertThatTheStrings(selectorTokens).areNotBlank();
        this.selectorId = optionalSelectorId;
        this.selectorType = optionalSelectorType;
        this.selectorRoles = ImmutableList.forIterable(selectorRoles);
        this.selectorTokens = ImmutableList.forIterable(selectorTokens);
    }

    public final boolean containsSelectorRole(String selectorRole) {
        return this.selectorRoles.containsEqualing(selectorRole);
    }

    public final boolean containsSelectorRoles() {
        return this.selectorRoles.containsAny();
    }

    public final boolean containsSelectorToken(String selectorToken) {
        return this.selectorTokens.containsEqualing(selectorToken);
    }

    public final boolean containsSelectorTokens() {
        return this.selectorTokens.containsAny();
    }

    @Override
    public final IContainer<INode<?>> getAttributes() {
        LinkedList<INode<?>> attributes = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode(SELECTOR_ID_HEADER, this.getSelectorId(), new String[0]));
        }
        if (this.hasSelectorType()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode(SELECTOR_TYPE_HEADER, this.getSelectorType(), new String[0]));
        }
        for (String r : this.getSelectorRoles()) {
            attributes.addAtEnd(Node.withHeaderAndChildNode(SELECTOR_ROLE_HEADER, r, new String[0]));
        }
        for (IAttachingAttribute a : this.getAttachingAttributes()) {
            attributes.addAtEnd(a.getSpecification());
        }
        for (ISelectingStyleWithSelectors s : this.getSubStyles()) {
            attributes.addAtEnd(s.getSpecification());
        }
        return attributes;
    }

    @Override
    public final String getSelectorId() {
        this.assertHasSelectorId();
        return this.selectorId;
    }

    @Override
    public final IContainer<String> getSelectorRoles() {
        return this.selectorRoles;
    }

    @Override
    public final IContainer<String> getSelectorTokens() {
        return this.selectorTokens;
    }

    @Override
    public final String getSelectorType() {
        this.assertHasSelectorType();
        return this.selectorType;
    }

    @Override
    public final boolean hasSelectorId() {
        return this.selectorId != null;
    }

    public final boolean hasSelectorId(String selectorId) {
        if (!this.hasSelectorId()) {
            return false;
        }
        return this.getSelectorId().equals(selectorId);
    }

    @Override
    public final boolean hasSelectorType() {
        return this.selectorType != null;
    }

    public final boolean hasSelectorType(Class<?> selectorType) {
        return selectorType != null && this.hasSelectorType(selectorType.getSimpleName());
    }

    public final boolean hasSelectorType(String selectorType) {
        if (!this.hasSelectorType()) {
            return false;
        }
        return this.getSelectorType().equals(selectorType);
    }

    @Override
    public final boolean selectsElement(IStylableElement<?> element) {
        return this.selectorIdAllowsToSelectElement(element) && this.selectorTypeAllowsToSelectElement(element) && this.selectorRolesAllowToSelectElement(element) && this.selectorTokensAllowToSelectElement(element);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorRole(Enum<?> selectorRole, Enum<?> ... selectorRoles) {
        IContainer<String> allSelectorRoles = ContainerView.forElementAndArray(selectorRole, selectorRoles).to(Object::toString);
        return this.withSelectorRoles(allSelectorRoles);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorRole(String selectorRole, String ... selectorRoles) {
        ContainerView<String> allSelectorRoles = ContainerView.forElementAndArray(selectorRole, selectorRoles);
        return this.withSelectorRoles(allSelectorRoles);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorToken(String selectorToken, String ... selectorTokens) {
        ContainerView<String> allSelectorTokens = ContainerView.forElementAndArray(selectorToken, selectorTokens);
        return this.withSelectorTokens(allSelectorTokens);
    }

    @Override
    public final ISelectingStyleWithSelectors withSelectorType(Class<?> selectorType) {
        return this.withSelectorType(selectorType.getSimpleName());
    }

    private void assertHasSelectorId() {
        if (!this.hasSelectorId()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "selector id");
        }
    }

    private void assertHasSelectorType() {
        if (!this.hasSelectorType()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "selector type");
        }
    }

    private boolean selectorIdAllowsToSelectElement(IStylableElement<?> element) {
        return !this.hasSelectorId() || element.hasId(this.getSelectorId());
    }

    private boolean selectorRolesAllowToSelectElement(IStylableElement<?> element) {
        if (this.containsSelectorRoles()) {
            if (!this.getSelectorRoles().containsAny(element::hasRole)) {
                return false;
            }
        }
        return true;
    }

    private boolean selectorTokensAllowToSelectElement(IStylableElement<?> element) {
        return !this.containsSelectorTokens() || this.getSelectorTokens().containsAnyOf(element.getTokens());
    }

    private boolean selectorTypeAllowsToSelectElement(IStylableElement<?> element) {
        return !this.hasSelectorType() || element.isOfType(this.getSelectorType());
    }
}

