/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.style.model.AbstractSelectingStyle;
import ch.nolix.system.style.model.AttachingAttribute;
import ch.nolix.system.style.model.DeepSelectingStyle;
import ch.nolix.system.style.model.SelectingStyle;
import ch.nolix.systemapi.style.model.IAbstractStyle;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.stylable.IStylableElement;

abstract class AbstractStyle<S extends IAbstractStyle<S>>
extends AbstractElement
implements IAbstractStyle<S> {
    protected static final String ATTACHING_ATTRIBUTE_HEADER = "AttachingAttribute";
    private final ImmutableList<AttachingAttribute> attachingAttributes;
    private final ImmutableList<AbstractSelectingStyle> subStyles;

    protected AbstractStyle(IContainer<? extends IAttachingAttribute> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        this.attachingAttributes = ImmutableList.forIterable(attachingAttributes.to(AttachingAttribute::fromAttachingAttribute));
        this.subStyles = ImmutableList.forIterable(subStyles.to(this::createSelectingStyleFromSelectingStyle));
    }

    @Override
    public final IContainer<? extends IAttachingAttribute> getAttachingAttributes() {
        return this.attachingAttributes;
    }

    @Override
    public final IContainer<? extends ISelectingStyleWithSelectors> getSubStyles() {
        return this.subStyles;
    }

    @Override
    public final boolean hasAttachingAttributes() {
        return this.attachingAttributes.containsAny();
    }

    @Override
    public final S withAttachingAttribute(Enum<?> tag, String value) {
        AttachingAttribute attachingAttribute = AttachingAttribute.forTagAndValue(tag, value);
        ImmutableList<AttachingAttribute> attachingAttribtues = ImmutableList.withElement(attachingAttribute, new AttachingAttribute[0]);
        return this.withAttachingAttributes(attachingAttribtues);
    }

    @Override
    public final S withAttachingAttribute(String attachingAttribute, String ... attachingAttributes) {
        LinkedList allAttachingAttributes = LinkedList.createEmpty();
        allAttachingAttributes.addAtEnd(AttachingAttribute.forValue(attachingAttribute));
        String[] stringArray = attachingAttributes;
        int n = attachingAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            allAttachingAttributes.addAtEnd(AttachingAttribute.forValue(a));
            ++n2;
        }
        return this.withAttachingAttributes(allAttachingAttributes);
    }

    @Override
    public final S withNewAttachingAttributesWhereSelectorType(String selectorType, String newAttachingAttribute, String ... newAttachingAttributes) {
        ContainerView<String> allNewAttachingAttribtues = ContainerView.forElementAndArray(newAttachingAttribute, newAttachingAttributes);
        return this.withNewAttachingAttributesWhereSelectorType(selectorType, allNewAttachingAttribtues);
    }

    @Override
    public final S withReplacedAttachingAttributes(IPair<String, String> attachingAttributeReplacement, IPair<String, String> ... attachingAttributeReplacements) {
        ContainerView<IPair<String, String>> allAttachingAttributeReplacements = ContainerView.forElementAndArray(attachingAttributeReplacement, attachingAttributeReplacements);
        return this.withReplacedAttachingAttributes(allAttachingAttributeReplacements);
    }

    @Override
    public final S withReplacedTaggedAttachingAttributes(IPair<Enum<?>, String> attachingAttributeReplacement, IPair<Enum<?>, String> ... attachingAttributeReplacements) {
        ContainerView<IPair<Enum<?>, String>> allAttachingAttributeReplacements = ContainerView.forElementAndArray(attachingAttributeReplacement, attachingAttributeReplacements);
        return this.withReplacedTaggedAttachingAttributes(allAttachingAttributeReplacements);
    }

    @Override
    public final S withSubStyle(ISelectingStyleWithSelectors subStyle, ISelectingStyleWithSelectors ... subStyles) {
        ContainerView<ISelectingStyleWithSelectors> allSubStyles = ContainerView.forElementAndArray(subStyle, subStyles);
        return this.withSubStyles(allSubStyles);
    }

    protected final void setAttachingAttributesToElement(IStylableElement<?> element) {
        for (IAttachingAttribute a : this.getAttachingAttributes()) {
            try {
                element.addOrChangeAttribute((INode)a.getValue());
            }
            catch (Throwable error) {
                InvalidArgumentException invalidArgumentException = InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(a, "attaching attribute", "could not be added to the given " + element.getType() + " '" + String.valueOf(element.getSpecification()) + "'");
                invalidArgumentException.initCause(error);
                throw invalidArgumentException;
            }
        }
    }

    protected final void letSubStylesStyleChildElementsOfElement(IStylableElement<?> element) {
        IContainer<IStylableElement<?>> childElements = element.getStoredChildStylableElements();
        this.getSubStyles().forEach(ss -> childElements.forEach(ss::applyToElement));
    }

    private AbstractSelectingStyle createSelectingStyleFromSelectingStyle(ISelectingStyleWithSelectors selectingStyle) {
        if (selectingStyle instanceof SelectingStyle) {
            SelectingStyle elementSelectingStyle = (SelectingStyle)selectingStyle;
            return elementSelectingStyle;
        }
        if (selectingStyle instanceof DeepSelectingStyle) {
            DeepSelectingStyle deepSelectingStyle = (DeepSelectingStyle)selectingStyle;
            return deepSelectingStyle;
        }
        throw InvalidArgumentException.forArgument(selectingStyle);
    }
}

