/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.style.tool.AttachingAttributeValidator;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.tool.IAttachingAttributeValidator;

public final class AttachingAttribute
extends AbstractElement
implements IAttachingAttribute {
    private static final IAttachingAttributeValidator ATTACHING_ATTRIBUTE_VALIDATOR = new AttachingAttributeValidator();
    private final String optionalTag;
    private final Node value;

    private AttachingAttribute(INode<?> value) {
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        this.optionalTag = null;
        this.value = Node.fromNode(value);
    }

    private AttachingAttribute(String tag, INode<?> value) {
        Validator.assertThat(tag).thatIsNamed("tag").isNotBlank();
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        this.optionalTag = tag;
        this.value = Node.fromNode(value);
    }

    private AttachingAttribute(String tag, String value) {
        Validator.assertThat(tag).thatIsNamed("tag").isNotBlank();
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        this.optionalTag = tag;
        this.value = Node.fromString(value);
    }

    public static AttachingAttribute forTagAndValue(Enum<?> tag, INode<?> value) {
        return new AttachingAttribute(tag.toString(), value);
    }

    public static AttachingAttribute forTagAndValue(Enum<?> tag, String value) {
        return new AttachingAttribute(tag.toString(), Node.fromString(value));
    }

    public static AttachingAttribute forValue(INode<?> value) {
        return new AttachingAttribute(value);
    }

    public static AttachingAttribute forValue(String value) {
        return new AttachingAttribute(Node.fromString(value));
    }

    public static AttachingAttribute fromAttachingAttribute(IAttachingAttribute attachingAttribute) {
        if (attachingAttribute instanceof AttachingAttribute) {
            AttachingAttribute concreteAttachingAttribute = (AttachingAttribute)attachingAttribute;
            return concreteAttachingAttribute;
        }
        if (attachingAttribute.hasTag()) {
            return new AttachingAttribute(attachingAttribute.getTag(), (INode)attachingAttribute.getValue());
        }
        return AttachingAttribute.forValue((INode)attachingAttribute.getValue());
    }

    public static AttachingAttribute fromSpecification(INode<?> specification) {
        IContainer<?> attributes = specification.getStoredChildNodes();
        return switch (attributes.getCount()) {
            case 1 -> AttachingAttribute.forValue((INode)attributes.getStoredAtOneBasedIndex(1));
            case 2 -> new AttachingAttribute(((INode)attributes.getStoredAtOneBasedIndex(1)).toString(), (INode)attributes.getStoredAtOneBasedIndex(2));
            default -> throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
        };
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        LinkedList<INode<?>> attributes = LinkedList.createEmpty();
        if (this.optionalTag != null) {
            attributes.addAtEnd(Node.withHeaderAndChildNode("Tag", this.optionalTag, new String[0]));
        }
        attributes.addAtEnd(this.value);
        return attributes;
    }

    @Override
    public String getTag() {
        ATTACHING_ATTRIBUTE_VALIDATOR.assertHasTag(this);
        return this.optionalTag;
    }

    @Override
    public Node getValue() {
        return this.value;
    }

    @Override
    public boolean hasTag() {
        return this.optionalTag != null;
    }

    @Override
    public boolean hasTag(Enum<?> tag) {
        return this.hasTag() && tag != null && this.getTag().equals(tag.toString());
    }

    @Override
    public IAttachingAttribute withValue(String value) {
        if (this.optionalTag != null) {
            return new AttachingAttribute(this.optionalTag, value);
        }
        return AttachingAttribute.forValue(value);
    }
}

