/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AbstractSelectingStyle;
import ch.nolix.system.style.model.AttachingAttribute;
import ch.nolix.system.style.model.SelectingStyle;
import ch.nolix.system.style.tool.AttributeMerger;
import ch.nolix.system.style.tool.AttributeReplacer;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.stylable.IStylableElement;
import ch.nolix.systemapi.style.tool.IAttributeMerger;
import ch.nolix.systemapi.style.tool.IAttributeReplacer;

public final class DeepSelectingStyle
extends AbstractSelectingStyle {
    public static final String TYPE_NAME = "DeepSelectingStyle";
    private static final IAttributeMerger ATTRIBUTE_MERGER = new AttributeMerger();
    private static final IAttributeReplacer ATTRIBUTE_REPLACER = new AttributeReplacer();

    public DeepSelectingStyle() {
        super(null, null, ImmutableList.createEmpty(), ImmutableList.createEmpty(), ImmutableList.createEmpty(), ImmutableList.createEmpty());
    }

    public DeepSelectingStyle(String optionalSelectorId, String optionalSelectorType, IContainer<String> selectorRoles, IContainer<String> selectorTokens, IContainer<? extends IAttachingAttribute> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        super(optionalSelectorId, optionalSelectorType, selectorRoles, selectorTokens, attachingAttributes, subStyles);
    }

    public static DeepSelectingStyle fromSpecification(INode<?> specification) {
        String optionalselectorId = null;
        String optionalSelectorType = null;
        LinkedList<String> selectorRoles = LinkedList.createEmpty();
        LinkedList<String> selectorTokens = LinkedList.createEmpty();
        LinkedList attachingAttributes = LinkedList.createEmpty();
        LinkedList subStyles = LinkedList.createEmpty();
        for (INode a : specification.getStoredChildNodes()) {
            switch (a.getHeader()) {
                case "SelectorId": {
                    optionalselectorId = a.getSingleChildNodeHeader();
                    break;
                }
                case "SelectorType": {
                    optionalSelectorType = a.getSingleChildNodeHeader();
                    break;
                }
                case "SelectorRole": {
                    selectorRoles.addAtEnd(a.getSingleChildNodeHeader());
                    break;
                }
                case "SelectorToken": {
                    selectorTokens.addAtEnd(a.getSingleChildNodeHeader());
                    break;
                }
                case "AttachingAttribute": {
                    attachingAttributes.addAtEnd(AttachingAttribute.fromSpecification(a));
                    break;
                }
                case "SelectingStyle": {
                    subStyles.addAtEnd(SelectingStyle.fromSpecification(a));
                    break;
                }
                case "DeepSelectingStyle": {
                    subStyles.addAtEnd(DeepSelectingStyle.fromSpecification(a));
                    break;
                }
                default: {
                    throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
                }
            }
        }
        return new DeepSelectingStyle(optionalselectorId, optionalSelectorType, selectorRoles, selectorTokens, attachingAttributes, subStyles);
    }

    @Override
    public boolean selectsChildElements() {
        return true;
    }

    @Override
    public void applyToElement(IStylableElement<?> element) {
        if (this.selectsElement(element)) {
            this.setAttachingAttributesToElement(element);
            this.letSubStylesStyleChildElementsOfElement(element);
        }
        this.styleChildElementsOfElement(element);
    }

    @Override
    public ISelectingStyleWithSelectors withAttachingAttributes(IContainer<? extends IAttachingAttribute> attachingAttributes) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        ContainerView<IAttachingAttribute> allAttachingAttributes = ContainerView.forIterable(this.getAttachingAttributes(), attachingAttributes);
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), allAttachingAttributes, this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withNewAttachingAttributesWhereSelectorType(String selectorType, IContainer<String> newAttachingAttributes) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        IContainer<IAttachingAttribute> attachingAttributes = this.hasSelectorType(selectorType) ? ATTRIBUTE_MERGER.getAttributesMergedWithNewAttributes(this.getAttachingAttributes(), newAttachingAttributes) : this.getAttachingAttributes();
        IContainer<ISelectingStyleWithSelectors> subStylesWithNewAttachingAttributes = this.getSubStyles().to(ss -> (ISelectingStyleWithSelectors)ss.withNewAttachingAttributesWhereSelectorType(selectorType, newAttachingAttributes));
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), attachingAttributes, subStylesWithNewAttachingAttributes);
    }

    @Override
    public ISelectingStyleWithSelectors withReplacedAttachingAttributes(IContainer<IPair<String, String>> attachingAttributeReplacements) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        IContainer<IAttachingAttribute> replacedAttachingAttributes = ATTRIBUTE_REPLACER.getReplacedAttributesFromAttributesAndAttributeReplacements(this.getAttachingAttributes(), attachingAttributeReplacements);
        IContainer<ISelectingStyleWithSelectors> subStylesWithReplacedAttachingAttributes = this.getSubStyles().to(ss -> (ISelectingStyleWithSelectors)ss.withReplacedAttachingAttributes(attachingAttributeReplacements));
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), replacedAttachingAttributes, subStylesWithReplacedAttachingAttributes);
    }

    @Override
    public ISelectingStyleWithSelectors withReplacedTaggedAttachingAttributes(IContainer<IPair<Enum<?>, String>> attachingAttributeReplacements) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        IContainer<IAttachingAttribute> replacedAttachingAttributes = ATTRIBUTE_REPLACER.getReplacedTaggedAttributesFromAttributesAndAttributeReplacements(this.getAttachingAttributes(), attachingAttributeReplacements);
        IContainer<ISelectingStyleWithSelectors> subStylesWithReplacedAttachingAttributes = this.getSubStyles().to(ss -> (ISelectingStyleWithSelectors)ss.withReplacedTaggedAttachingAttributes(attachingAttributeReplacements));
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), replacedAttachingAttributes, subStylesWithReplacedAttachingAttributes);
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorId(String selectorId) {
        Validator.assertThat(selectorId).thatIsNamed("selector id").isNotBlank();
        String optionalSelectorType = null;
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        return new DeepSelectingStyle(selectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorRoles(IContainer<String> selectorRoles) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList<String> allSelectorRoles = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        allSelectorRoles.addAtEnd(this.getSelectorRoles());
        allSelectorRoles.addAtEnd(selectorRoles);
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, allSelectorRoles, this.getSelectorTokens(), this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorTokens(IContainer<String> selectorTokens) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList<String> allSelectorTokens = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        allSelectorTokens.addAtEnd(this.getSelectorTokens());
        allSelectorTokens.addAtEnd(selectorTokens);
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), allSelectorTokens, this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSelectorType(String selectorType) {
        Validator.assertThat(selectorType).thatIsNamed("selector type").isNotBlank();
        String optionalSelectorId = null;
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        return new DeepSelectingStyle(optionalSelectorId, selectorType, this.getSelectorRoles(), this.getSelectorTokens(), this.getAttachingAttributes(), this.getSubStyles());
    }

    @Override
    public ISelectingStyleWithSelectors withSubStyles(IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        String optionalSelectorId = null;
        String optionalSelectorType = null;
        LinkedList allSubStyles = LinkedList.createEmpty();
        if (this.hasSelectorId()) {
            optionalSelectorId = this.getSelectorId();
        }
        if (this.hasSelectorType()) {
            optionalSelectorType = this.getSelectorType();
        }
        allSubStyles.addAtEnd(this.getSubStyles());
        allSubStyles.addAtEnd(subStyles);
        return new DeepSelectingStyle(optionalSelectorId, optionalSelectorType, this.getSelectorRoles(), this.getSelectorTokens(), this.getAttachingAttributes(), allSubStyles);
    }

    private void styleChildElementsOfElement(IStylableElement<?> element) {
        IContainer<IStylableElement<?>> childElements = element.getStoredChildStylableElements();
        childElements.forEach(this::applyToElement);
    }
}

