/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.style.model.AbstractStyle;
import ch.nolix.system.style.model.AttachingAttribute;
import ch.nolix.system.style.model.DeepSelectingStyle;
import ch.nolix.system.style.model.SelectingStyle;
import ch.nolix.system.style.tool.AttributeReplacer;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.model.ISelectingStyleWithSelectors;
import ch.nolix.systemapi.style.model.IStyle;
import ch.nolix.systemapi.style.stylable.IStylableElement;
import ch.nolix.systemapi.style.tool.IAttributeReplacer;

public final class Style
extends AbstractStyle<IStyle>
implements IStyle {
    private static final IAttributeReplacer ATTRIBUTE_REPLACER = new AttributeReplacer();

    public Style() {
        super(ImmutableList.createEmpty(), ImmutableList.createEmpty());
    }

    public Style(IContainer<? extends IAttachingAttribute> attachingAttributes, IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        super(attachingAttributes, subStyles);
    }

    public static Style fromFile(String filePath) {
        Node specification = Node.fromFile(filePath);
        return Style.fromSpecification(specification);
    }

    public static Style fromSpecification(INode<?> specification) {
        LinkedList attachingAttributes = LinkedList.createEmpty();
        LinkedList subStyles = LinkedList.createEmpty();
        for (INode a : specification.getStoredChildNodes()) {
            switch (a.getHeader()) {
                case "AttachingAttribute": {
                    attachingAttributes.addAtEnd(AttachingAttribute.fromSpecification(a));
                    break;
                }
                case "SelectingStyle": {
                    subStyles.addAtEnd(SelectingStyle.fromSpecification(a));
                    break;
                }
                case "DeepSelectingStyle": {
                    subStyles.addAtEnd(DeepSelectingStyle.fromSpecification(a));
                    break;
                }
                default: {
                    throw InvalidArgumentException.forArgumentAndArgumentName(specification, "specification");
                }
            }
        }
        return new Style(attachingAttributes, subStyles);
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return ContainerView.forIterable(this.getAttachingAttributes().to(IElement::getSpecification), this.getSubStyles().to(IElement::getSpecification));
    }

    @Override
    public void applyToElement(IStylableElement<?> element) {
        this.setAttachingAttributesToElement(element);
        this.letSubStylesStyleChildElementsOfElement(element);
    }

    @Override
    public IStyle withAttachingAttributes(IContainer<? extends IAttachingAttribute> attachingAttributes) {
        ContainerView<IAttachingAttribute> allAttachingAttributes = ContainerView.forIterable(this.getAttachingAttributes(), attachingAttributes);
        return new Style(allAttachingAttributes, this.getSubStyles());
    }

    @Override
    public IStyle withNewAttachingAttributesWhereSelectorType(String selectorType, IContainer<String> newAttachingAttributes) {
        IContainer<ISelectingStyleWithSelectors> subStylesWtihNewAttachingAttribtues = this.getSubStyles().to(ss -> (ISelectingStyleWithSelectors)ss.withNewAttachingAttributesWhereSelectorType(selectorType, newAttachingAttributes));
        return new Style(this.getAttachingAttributes(), subStylesWtihNewAttachingAttribtues);
    }

    @Override
    public IStyle withReplacedAttachingAttributes(IContainer<IPair<String, String>> attachingAttributeReplacements) {
        IContainer<IAttachingAttribute> replacedAttachingAttributes = ATTRIBUTE_REPLACER.getReplacedAttributesFromAttributesAndAttributeReplacements(this.getAttachingAttributes(), attachingAttributeReplacements);
        IContainer<ISelectingStyleWithSelectors> subStylesWithReplacedAttachingAttributes = this.getSubStyles().to(ss -> (ISelectingStyleWithSelectors)ss.withReplacedAttachingAttributes(attachingAttributeReplacements));
        return new Style(replacedAttachingAttributes, subStylesWithReplacedAttachingAttributes);
    }

    @Override
    public IStyle withReplacedTaggedAttachingAttributes(IContainer<IPair<Enum<?>, String>> attachingAttributeReplacements) {
        IContainer<IAttachingAttribute> replacedAttachingAttributes = ATTRIBUTE_REPLACER.getReplacedTaggedAttributesFromAttributesAndAttributeReplacements(this.getAttachingAttributes(), attachingAttributeReplacements);
        IContainer<ISelectingStyleWithSelectors> subStylesWithReplacedAttachingAttributes = this.getSubStyles().to(ss -> (ISelectingStyleWithSelectors)ss.withReplacedTaggedAttachingAttributes(attachingAttributeReplacements));
        return new Style(replacedAttachingAttributes, subStylesWithReplacedAttachingAttributes);
    }

    @Override
    public IStyle withStyle(IStyle style) {
        return (IStyle)this.withAttachingAttributes(style.getAttachingAttributes()).withSubStyles(style.getSubStyles());
    }

    @Override
    public IStyle withSubStyles(IContainer<? extends ISelectingStyleWithSelectors> subStyles) {
        LinkedList allSubStyles = LinkedList.createEmpty();
        allSubStyles.addAtEnd(this.getSubStyles());
        allSubStyles.addAtEnd(subStyles);
        return new Style(this.getAttachingAttributes(), allSubStyles);
    }
}

