/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.counterpartupdater;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.web.cssmodel.ICss;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.webapplication.counterpart.IUpdateCommandCreator;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.Optional;

public final class UpdateCommandCreator
implements IUpdateCommandCreator {
    @Override
    public IChainedNode createSetCssCommandFromWebGui(IWebGui<?> webGui) {
        return this.createSetCssCommandFromCss(webGui.getCss());
    }

    @Override
    public IChainedNode createSetEventFunctionsCommandFromWebGui(IWebGui<?> webGui) {
        return this.createSetEventFunctionsCommandFromHtmlElementEventRegistrations(webGui.getHtmlElementEventRegistrations());
    }

    @Override
    public IChainedNode createSetIconCommandFromWebGui(IWebGui<?> webGui) {
        return this.createSetIconCommandForIcon(webGui.getIcon());
    }

    @Override
    public IChainedNode createSetIconCommandForIcon(IImage icon) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNode("SetIcon", icon.getSpecification()));
    }

    @Override
    public IChainedNode createSetRootHtmlElementCommandFromControl(IControl<?, ?> control) {
        return this.createSetHtmlElementCommandFromHtmlElement(control.getInternalId(), control.getHtml());
    }

    @Override
    public IChainedNode createSetRootHtmlElementCommandFromWebGui(IWebGui<?> webGui) {
        return this.createSetRootHtmlElementCommandFromHtmlElement(webGui.getHtml());
    }

    @Override
    public IChainedNode createSetTitleCommandFromWebGui(IWebGui<?> webGui) {
        return this.createSetTitleCommandForTitle(webGui.getTitle());
    }

    @Override
    public IChainedNode createSetTitleCommandForTitle(String title) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodesFromNodes("SetTitle", Node.withHeader(title), new INode[0]));
    }

    @Override
    public IChainedNode createSetUserInputFunctionsCommandFromWebGui(IWebGui<?> webGui) {
        return this.createSetUserInputFunctionsCommandForControls(webGui.getStoredControls());
    }

    private ChainedNode createSetCssCommandFromCss(ICss css) {
        return this.createSetCssCommandFromCss(css.toStringWithoutEnclosingBrackets());
    }

    private ChainedNode createSetCssCommandFromCss(String css) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNode("SetCSS", ChainedNode.withHeader(css)));
    }

    private ChainedNode createSetHtmlElementCommandFromHtmlElement(String htmlElementId, IHtmlElement htmlElement) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodes("SetHTMLElement", ChainedNode.withHeader(htmlElementId), ChainedNode.withHeader(htmlElement.toString())));
    }

    private ChainedNode createSetEventFunctionsCommandFromHtmlElementEventRegistrations(IContainer<IHtmlElementEvent> htmlElementEventRegistrations) {
        IContainer<Node> eventFunctions = htmlElementEventRegistrations.to(e -> Node.withChildNode(Node.withHeader(e.getHtmlElementId()), Node.withHeader(e.getHtmlEvent())));
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodesFromNodes("SetEventFunctions", eventFunctions));
    }

    private ChainedNode createSetRootHtmlElementCommandFromHtmlElement(IHtmlElement htmlElement) {
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNode("SetRootHTMLElement", ChainedNode.withHeader(htmlElement.toString())));
    }

    private ChainedNode createSetUserInputFunctionsCommandForControls(IContainer<IControl<?, ?>> controls) {
        LinkedList userInputFunctions = LinkedList.createEmpty();
        for (IControl iControl : controls) {
            Optional<String> userInputFunction = iControl.getOptionalJavaScriptUserInputFunction();
            if (!userInputFunction.isPresent()) continue;
            userInputFunctions.addAtEnd(this.createUserInputFunctionFromControlAndString(iControl, userInputFunction.get()));
        }
        return ChainedNode.withHeaderAndNextNode("GUI", ChainedNode.withHeaderAndChildNodes("SetUserInputFunctions", userInputFunctions));
    }

    private ChainedNode createUserInputFunctionFromControlAndString(IControl<?, ?> control, String string) {
        return ChainedNode.withChildNodesFromNodes(Node.withHeader(control.getInternalId()), Node.withHeader(string));
    }
}

