/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.main;

import ch.nolix.systemapi.webapplication.component.IComponent;
import ch.nolix.systemapi.webapplication.component.RefreshBehavior;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public final class WebClientHtmlEventExecutor {
    public void runHtmlEventOfTriggeredControlAndUpdateAccordingly(IControl<?, ?> triggeredControl, String htmlEvent, BooleanSupplier openStateRequester, Runnable guiUpdater, Consumer<IControl<?, ?>> controlUpdater) {
        IWebGui<?> gui = triggeredControl.getStoredParentGui();
        int originalLayerCount = gui.getLayerCount();
        triggeredControl.runHtmlEvent(htmlEvent);
        RefreshBehavior refreshBehaviour = this.getRefreshBehavior(triggeredControl, originalLayerCount, openStateRequester);
        switch (refreshBehaviour) {
            case REFRESH_GUI: {
                guiUpdater.run();
                break;
            }
            case REFRESH_SELF: {
                IControl<?, ?> controlToUpdate = this.getStoredControlToUpdateFromTriggeredConntrol(triggeredControl);
                controlUpdater.accept(controlToUpdate);
            }
        }
    }

    private Optional<IControl<?, ?>> getOptionalStoredParentComponentOfControl(IControl<?, ?> control) {
        Object e;
        if (control.isLinkedToAnObject() && (e = control.getStoredLinkedObjects().getStoredFirst()) instanceof IComponent) {
            IComponent component = (IComponent)e;
            return Optional.of(component);
        }
        if (control.belongsToControl()) {
            return this.getOptionalStoredParentComponentOfControl(control.getStoredParentControl());
        }
        return Optional.empty();
    }

    private RefreshBehavior getRefreshBehavior(IControl<?, ?> triggeredControl, int originalLayerCount, BooleanSupplier openStateRequester) {
        if (!openStateRequester.getAsBoolean()) {
            return RefreshBehavior.DO_NOT_REFRESH_ANYTHING;
        }
        if (!triggeredControl.belongsToGui()) {
            return RefreshBehavior.REFRESH_GUI;
        }
        IWebGui<?> gui = triggeredControl.getStoredParentGui();
        int layerCount = gui.getLayerCount();
        if (layerCount != originalLayerCount || !gui.containsControl(triggeredControl)) {
            return RefreshBehavior.REFRESH_GUI;
        }
        return RefreshBehavior.REFRESH_SELF;
    }

    private IControl<?, ?> getStoredControlToUpdateFromTriggeredConntrol(IControl<?, ?> triggeredControl) {
        Optional<IControl<?, ?>> componentContainer = this.getOptionalStoredParentComponentOfControl(triggeredControl);
        return componentContainer.orElse(triggeredControl);
    }
}

