/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.container;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.web.htmlelementmodel.HtmlElement;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.systemapi.webgui.container.IGrid;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.IControl;

public final class GridHtmlBuilder
implements IControlHtmlBuilder<IGrid> {
    @Override
    public IHtmlElement createHtmlElementForControl(IGrid control) {
        return HtmlElement.withTypeAndChildElement("div", this.createHtmlElementForTableOfGrid(control), new IHtmlElement[0]);
    }

    public HtmlElement createHtmlElementForTableOfGrid(IGrid control) {
        return HtmlElement.withTypeAndChildElement("table", this.createHtmlElementForTableBodyOfGrid(control), new IHtmlElement[0]);
    }

    private HtmlElement createHtmlElementForTableBodyOfGrid(IGrid grid) {
        return HtmlElement.withTypeAndChildElements("tbody", this.createHtmlElementsForChildControlsOfGrid(grid));
    }

    private IContainer<IHtmlElement> createHtmlElementsForChildControlsOfGrid(IGrid grid) {
        LinkedList<IHtmlElement> htmlElements = LinkedList.createEmpty();
        int ri = 1;
        while (ri <= grid.getRowCount()) {
            htmlElements.addAtEnd(this.createHtmlElementForRowOfGrid(grid, ri));
            ++ri;
        }
        return htmlElements;
    }

    private HtmlElement createHtmlElementForRowOfGrid(IGrid grid, int rowIndex) {
        return HtmlElement.withTypeAndChildElements("tr", this.createHtmlElementsForCellsOfRowOfGrid(grid, rowIndex));
    }

    private IContainer<IHtmlElement> createHtmlElementsForCellsOfRowOfGrid(IGrid grid, int rowIndex) {
        LinkedList<IHtmlElement> htmlElements = LinkedList.createEmpty();
        int ci = 1;
        while (ci <= grid.getColumnCount()) {
            htmlElements.addAtEnd(this.createHtmlElementForCellOfGrid(grid, rowIndex, ci));
            ++ci;
        }
        return htmlElements;
    }

    private HtmlElement createHtmlElementForCellOfGrid(IGrid grid, int rowIndex, int columnIndex) {
        if (!grid.containsControlAtOneBasedRowAndColumnIndex(rowIndex, columnIndex)) {
            return HtmlElement.withType("td");
        }
        IControl<?, ?> childControl = grid.getStoredChildControlAtOneBasedRowAndColumnIndex(rowIndex, columnIndex);
        IHtmlElement childControlHtmlElement = childControl.getHtml();
        return HtmlElement.withTypeAndChildElement("td", childControlHtmlElement, new IHtmlElement[0]);
    }
}

