/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.itemmenu.base;

import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.element.property.OptionalValue;
import ch.nolix.system.element.property.Value;
import ch.nolix.systemapi.gui.selection.Selectable;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenu;
import ch.nolix.systemapi.webgui.itemmenu.baseapi.IItemMenuItem;
import java.util.function.Consumer;

public final class ItemMenuItem
extends AbstractMutableElement
implements IItemMenuItem<ItemMenuItem> {
    public static final boolean DEFAULT_SELECTION_FLAG = false;
    private static final String ID_HEADER = "Id";
    private static final String TEXT_HEADER = "Text";
    private static final String SELECTION_FLAG_HEADER = "Selected";
    private final OptionalValue<String> id = new OptionalValue<String>("Id", this::setId, INode::getSingleChildNodeHeader, string -> Node.withChildNode(string, new String[0]));
    private final Value<String> text = new Value<String>("Text", this::setText, INode::getSingleChildNodeHeader, string -> Node.withChildNode(string, new String[0]));
    private final MutableValue<Boolean> selectionFlag = new MutableValue<Boolean>("Selected", false, this::setSelectionFlag, INode::getSingleChildNodeAsBoolean, Node::withChildNode);
    private IItemMenu<?, ?> parentMenu;
    private final Consumer<IItemMenuItem<?>> selectAction;

    private ItemMenuItem() {
        this.selectAction = null;
    }

    private ItemMenuItem(Consumer<IItemMenuItem<?>> selectAction) {
        Validator.assertThat(selectAction).thatIsNamed("select action").isNotNull();
        this.selectAction = selectAction;
    }

    public static ItemMenuItem createBlankItem() {
        return ItemMenuItem.withText("");
    }

    public static ItemMenuItem fromSpecification(INode<?> specification) {
        ItemMenuItem item = new ItemMenuItem();
        item.resetFromSpecification(specification);
        return item;
    }

    public static ItemMenuItem withIdAndText(String id, String text) {
        ItemMenuItem item = new ItemMenuItem();
        item.setId(id);
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withIdAndTextAndSelectAction(String id, String text, Runnable selectAction) {
        ItemMenuItem item = new ItemMenuItem(i -> selectAction.run());
        item.setId(id);
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withIdAndTextAndSelectAction(String id, String text, Consumer<IItemMenuItem<?>> selectAction) {
        ItemMenuItem item = new ItemMenuItem(selectAction);
        item.setId(id);
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withText(String text) {
        ItemMenuItem item = new ItemMenuItem();
        item.setId(IdCreator.createIdOf10HexadecimalCharacters());
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withTextAndSelectAction(String text, Runnable selectAction) {
        ItemMenuItem item = new ItemMenuItem(i -> selectAction.run());
        item.setId(IdCreator.createIdOf10HexadecimalCharacters());
        item.setText(text);
        return item;
    }

    public static ItemMenuItem withTextAndSelectAction(String text, Consumer<IItemMenuItem<?>> selectAction) {
        ItemMenuItem item = new ItemMenuItem(selectAction);
        item.setId(IdCreator.createIdOf10HexadecimalCharacters());
        item.setText(text);
        return item;
    }

    @Override
    public boolean belongsToMenu() {
        return this.parentMenu != null;
    }

    @Override
    public String getId() {
        return (String)this.id.getValue();
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    @Override
    public boolean isBlank() {
        return this.getText().isEmpty();
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.selectionFlag.getValue();
    }

    @Override
    public void reset() {
        this.unselect();
    }

    @Override
    public void select() {
        if (!this.isSelected()) {
            this.selectWhenNotSelected();
        }
    }

    @Override
    public void unselect() {
        this.selectionFlag.setValue(false);
    }

    @Override
    public void internalSetParentMenu(IItemMenu<?, ?> parentMenu) {
        Validator.assertThat(parentMenu).thatIsNamed("parent menu").isNotNull();
        this.parentMenu = parentMenu;
    }

    private boolean hasSelectAction() {
        return this.selectAction != null;
    }

    private void runOptionalSelectAction() {
        if (this.hasSelectAction()) {
            this.selectAction.accept(this);
        }
    }

    private void selectWhenNotSelected() {
        this.unselectItemsOfOptionalParentMenu();
        this.selectionFlag.setValue(true);
        if (this.belongsToMenu()) {
            this.parentMenu.internalRunOptionalSelectActionForItem(this);
        }
        this.runOptionalSelectAction();
    }

    private void setId(String id) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        this.id.setValue(id);
    }

    private void setSelectionFlag(boolean selected) {
        if (selected) {
            this.select();
        } else {
            this.unselect();
        }
    }

    private void setText(String text) {
        this.text.setValue(text);
    }

    private void unselectItemsOfOptionalParentMenu() {
        if (this.belongsToMenu()) {
            this.parentMenu.getStoredItems().forEach(Selectable::unselect);
        }
    }
}

