/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.web.cssmodel.Css;
import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.core.web.cssmodel.CssRule;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.coreapi.web.cssmodel.ICssRule;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.IWebGui;

public final class WebGuiCssBuilder {
    public Css createCssForWebGui(IWebGui<?> webGui) {
        LinkedList<ICssRule> cssRules = LinkedList.createEmpty();
        this.fillUpCssRulesOfWebGuiIntoList(webGui, cssRules);
        return Css.withRules(cssRules);
    }

    private void fillUpCssRulesOfWebGuiIntoList(IWebGui<?> webGui, ILinkedList<ICssRule> cssRules) {
        cssRules.addAtEnd(CssRule.withSelectorAndProperties("body", ImmutableList.withElement(CssProperty.withNameAndValue("margin", "0px"), new CssProperty[0])));
        cssRules.addAtEnd(CssRule.withSelectorAndProperty("#root", CssProperty.withNameAndValue("min-height", "100vh"), new ICssProperty[0]));
        if (webGui.hasBackground()) {
            cssRules.addAtEnd(CssRule.withSelectorAndProperties("#root", webGui.getBackground().toCssProperties()));
        }
        this.fillUpCssRulesOfLayersOfWebGuiIntoList(webGui, cssRules);
    }

    private void fillUpCssRulesOfLayersOfWebGuiIntoList(IWebGui<?> webGui, ILinkedList<ICssRule> cssRules) {
        for (ILayer iLayer : webGui.getStoredLayers()) {
            this.fillUpCssRulesOfLayerIntoList(iLayer, cssRules);
        }
    }

    private void fillUpCssRulesOfLayerIntoList(ILayer<?> layer, ILinkedList<ICssRule> cssRules) {
        cssRules.addAtEnd(layer.getCssRule());
        for (IControl iControl : layer.getStoredControls()) {
            cssRules.addAtEnd(iControl.getCssRules());
        }
    }
}

