/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.fractal;

import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import ch.nolix.techapi.math.bigdecimalmath.ISequence;
import ch.nolix.techapi.math.fractal.IFractal;
import ch.nolix.techapi.math.fractal.IFractalTool;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class FractalTool
implements IFractalTool {
    @Override
    public BigDecimal getHeightInPixelAsBigDecimal(IFractal fractal) {
        return BigDecimal.valueOf(fractal.getHeightInPixel()).setScale(fractal.getDecimalPlaces());
    }

    @Override
    public BigDecimal getHeightInUnits(IFractal fractal) {
        return fractal.getImaginaryComponentInterval().getLength();
    }

    @Override
    public int getIterationCountForStartNumberWhereSquaredMagnitudeOfValueExceedsLimitOrMinusOne(IFractal fractal, IComplexNumber startNumber, BigDecimal limit) {
        ISequence<IComplexNumber> sequence = fractal.createSequenceFor(startNumber);
        return sequence.getIterationCountWhereSquaredMagnitudeOfValueExceedsLimitOrMinusOne(limit, fractal.getMaxIterationCount());
    }

    @Override
    public BigDecimal getMaxX(IFractal fractal) {
        return fractal.getRealComponentInterval().getMax();
    }

    @Override
    public BigDecimal getMaxY(IFractal fractal) {
        return fractal.getImaginaryComponentInterval().getMax();
    }

    @Override
    public BigDecimal getMinX(IFractal fractal) {
        return fractal.getRealComponentInterval().getMin();
    }

    @Override
    public BigDecimal getMinY(IFractal fractal) {
        return fractal.getImaginaryComponentInterval().getMin();
    }

    @Override
    public BigDecimal getPixelCountPerHorizontalUnit(IFractal fractal) {
        return this.getWidthInPixelAsBigDecimal(fractal).divide(this.getWidthInUnits(fractal), RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getPixelCountPerVerticalUnit(IFractal fractal) {
        return this.getHeightInPixelAsBigDecimal(fractal).divide(this.getHeightInUnits(fractal), RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getSquaredMinMagnitudeForDivergence(IFractal fractal) {
        return fractal.getMinMagnitudeForDivergence().pow(2).setScale(fractal.getDecimalPlaces());
    }

    @Override
    public BigDecimal getUnitsPerHorizontalPixel(IFractal fractal) {
        return this.getWidthInUnits(fractal).divide(this.getWidthInPixelAsBigDecimal(fractal), RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getUnitsPerVerticalPixel(IFractal fractal) {
        return this.getHeightInUnits(fractal).divide(this.getHeightInPixelAsBigDecimal(fractal), RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getUnitsForHorizontalPixelCount(IFractal fractal, double horizontalPixelCount) {
        return this.getUnitsPerHorizontalPixel(fractal).multiply(BigDecimal.valueOf(horizontalPixelCount));
    }

    @Override
    public BigDecimal getUnitsForVerticalPixelCount(IFractal fractal, double verticalPixelCount) {
        return this.getUnitsPerVerticalPixel(fractal).multiply(BigDecimal.valueOf(verticalPixelCount));
    }

    @Override
    public BigDecimal getWidthInPixelAsBigDecimal(IFractal fractal) {
        return BigDecimal.valueOf(fractal.getWidthInPixel()).setScale(fractal.getDecimalPlaces());
    }

    @Override
    public BigDecimal getWidthInUnits(IFractal fractal) {
        return fractal.getRealComponentInterval().getLength();
    }
}

