/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.template.webgui.dialog;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.objectcreation.builder.IBuilder;
import ch.nolix.system.webgui.atomiccontrol.button.Button;
import ch.nolix.system.webgui.atomiccontrol.label.Label;
import ch.nolix.system.webgui.atomiccontrol.textbox.Textbox;
import ch.nolix.system.webgui.atomiccontrol.validationlabel.ValidationLabel;
import ch.nolix.system.webgui.linearcontainer.HorizontalStack;
import ch.nolix.system.webgui.linearcontainer.VerticalStack;
import ch.nolix.system.webgui.main.Layer;
import ch.nolix.systemapi.webgui.atomiccontrol.buttonapi.ButtonRole;
import ch.nolix.systemapi.webgui.atomiccontrol.buttonapi.IButton;
import ch.nolix.systemapi.webgui.basecontainer.ContainerRole;
import ch.nolix.systemapi.webgui.linearcontainer.IVerticalStack;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.LayerRole;
import ch.nolix.template.webgui.dialog.EnterValueDialogBuilderHelper;
import java.util.function.Consumer;

public final class EnterValueDialogBuilder
implements IBuilder<ILayer<?>> {
    private static final String DEFAULT_INFO_TEXT = "Enter value";
    private static final String DEFAULT_ORIGINAL_VALUE = "";
    private static final String DEFAULT_CONFIRM_BUTTON_TEXT = "\u2714";
    private static final String DEFAULT_CANCEL_BUTTON_TEXT = "\u27f5";
    private static final Consumer<String> DEFAULT_VALUE_TAKER = value -> {};
    private String infoText = "Enter value";
    private String originalValue = "";
    private String cancelButtonText = "\u27f5";
    private String confirmButtonText = "\u2714";
    private Consumer<String> valueTaker = DEFAULT_VALUE_TAKER;

    @Override
    public ILayer<?> build() {
        Validator.assertThat(this.valueTaker).thatIsNamed("value taker").isNotNull();
        Textbox valueTextbox = new Textbox().setText(this.originalValue);
        return new Layer().setRole(LayerRole.DIALOG_LAYER).setRootControl((IControl)((IVerticalStack)new VerticalStack().setRole(ContainerRole.DIALOG_CONTAINER)).addControl(new Label().setText(this.getInfoText()), new IControl[]{new ValidationLabel(), valueTextbox, new HorizontalStack().addControl(((IButton)new Button().setRole(ButtonRole.CANCEL_BUTTON).setText(this.getCancelButtonText())).setLeftMouseButtonPressAction(b -> b.getStoredParentLayer().removeSelfFromGui()), ((IButton)new Button().setRole(ButtonRole.CONFIRM_BUTTON).setText(this.getConfirmButtonText())).setLeftMouseButtonPressAction(() -> EnterValueDialogBuilderHelper.confirmNewValue(valueTextbox, this.valueTaker)))}));
    }

    public EnterValueDialogBuilder setCancelButtonText(String cancelButtonText) {
        this.cancelButtonText = cancelButtonText;
        return this;
    }

    public EnterValueDialogBuilder setConfirmButtonText(String confirmButtonText) {
        this.confirmButtonText = confirmButtonText;
        return this;
    }

    public EnterValueDialogBuilder setInfoText(String infoText) {
        this.infoText = infoText;
        return this;
    }

    public EnterValueDialogBuilder setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
        return this;
    }

    public EnterValueDialogBuilder setValueTaker(Consumer<String> valueTaker) {
        this.valueTaker = valueTaker;
        return this;
    }

    private String getCancelButtonText() {
        return this.cancelButtonText;
    }

    private String getConfirmButtonText() {
        return this.confirmButtonText;
    }

    private String getInfoText() {
        return this.infoText;
    }
}

