package ch.nolix.system.graphic.color;

/**
 * Of the {@link X11ColorCatalog} an instance cannot be created.
 * 
 * @author Silvan Wyss
 * @version 2024-12-30
 * @see <a href="https://en.wikipedia.org/wiki/X11_color_names">X11 color
 *      names</a>
 */
public final class X11ColorCatalog {
  public static final int ALICE_BLUE_INT = 0xF0F8FF;

  public static final String ALICE_BLUE_STRING = "AliceBlue";

  public static final Color ALICE_BLUE = Color.fromLong(ALICE_BLUE_INT);

  public static final int ANTIQUE_WHITE_INT = 0xFAEBD7;

  public static final String ANTIQUE_WHITE_STRING = "AntiqueWhite";

  public static final Color ANTIQUE_WHITE = Color.fromLong(ANTIQUE_WHITE_INT);

  public static final int AQUA_INT = 0x00FFFF;

  public static final String AQUA_STRING = "Aqua";

  public static final Color AQUA = Color.fromLong(AQUA_INT);

  public static final int AQUAMARINE_INT = 0x7FFFD4;

  public static final String AQUAMARINE_STRING = "Aquamarine";

  public static final Color AQUAMARINE = Color.fromLong(AQUAMARINE_INT);

  public static final int AZURE_INT = 0xF0FFFF;

  public static final String AZURE_STRING = "Azure";

  public static final Color AZURE = Color.fromLong(AZURE_INT);

  public static final int BEIGE_INT = 0xF5F5DC;

  public static final String BEIGE_STRING = "Beige";

  public static final Color BEIGE = Color.fromLong(BEIGE_INT);

  public static final int BISQUE_INT = 0xFFE4C4;

  public static final String BISQUE_STRING = "Bisque";

  public static final Color BISQUE = Color.fromLong(BISQUE_INT);

  public static final int BLACK_INT = 0x000000;

  public static final String BLACK_STRING = "Black";

  public static final Color BLACK = Color.fromLong(BLACK_INT);

  public static final int BLANCHED_ALMOND_INT = 0xFFEBCD;

  public static final String BLANCHED_ALMOND_STRING = "BlacnhedAlmond";

  public static final Color BLANCHED_ALMOND = Color.fromLong(BLANCHED_ALMOND_INT);

  public static final int BLUE_INT = 0x0000FF;

  public static final String BLUE_STRING = "Blue";

  public static final Color BLUE = Color.fromLong(BLUE_INT);

  public static final int BLUE_VIOLET_INT = 0x8A2BE2;

  public static final String BLUE_VIOLET_STRING = "BlueViolet";

  public static final Color BLUE_VIOLET = Color.fromLong(BLUE_VIOLET_INT);

  public static final int BROWN_INT = 0xA52A2A;

  public static final String BROWN_STRING = "Brown";

  public static final Color BROWN = Color.fromLong(BROWN_INT);

  public static final int BURLY_WOOD_INT = 0xDEB887;

  public static final String BURLY_WOOD_STRING = "BurlyWood";

  public static final Color BURLY_WOOD = Color.fromLong(BURLY_WOOD_INT);

  public static final int CADET_BLUE_INT = 0x5F9EA0;

  public static final String CADET_BLUE_STRING = "CadetBlue";

  public static final Color CADET_BLUE = Color.fromLong(CADET_BLUE_INT);

  public static final int CHARTREUSE_INT = 0x7FFF00;

  public static final String CHARTREUSE_STRING = "Chartreuse";

  public static final Color CHARTREUSE = Color.fromLong(CHARTREUSE_INT);

  public static final int CHOCOLATE_INT = 0xD2691E;

  public static final String CHOCOLATE_STRING = "Chocolote";

  public static final Color CHOCOLATE = Color.fromLong(CHOCOLATE_INT);

  public static final int CORAL_INT = 0xFF7F50;

  public static final String CORAL_STRING = "Coral";

  public static final Color CORAL = Color.fromLong(CORAL_INT);

  public static final int CORNFLOWER_BLUE_INT = 0x6495ED;

  public static final String CORNFLOWER_BLUE_STRING = "CornflowerBlue";

  public static final Color CORNFLOWER_BLUE = Color.fromLong(CORNFLOWER_BLUE_INT);

  public static final int CORNSILK_INT = 0xFFF8DC;

  public static final String CORNSILK_STRING = "Cornsilk";

  public static final Color CORNSILK = Color.fromLong(CORNSILK_INT);

  public static final int CRIMSON_INT = 0xDC143C;

  public static final String CRIMSON_STRING = "Crimson";

  public static final Color CRIMSON = Color.fromLong(CRIMSON_INT);

  public static final int CYAN_INT = 0x00FFFF;

  public static final String CYAN_STRING = "Cyan";

  public static final Color CYAN = Color.fromLong(CYAN_INT);

  public static final int DARK_BLUE_INT = 0x00008B;

  public static final String DARK_BLUE_STRING = "DarkBlue";

  public static final Color DARK_BLUE = Color.fromLong(DARK_BLUE_INT);

  public static final int DARK_CYAN_INT = 0x008B8B;

  public static final String DARK_CYAN_STRING = "DarkCyan";

  public static final Color DARK_CYAN = Color.fromLong(DARK_CYAN_INT);

  public static final int DARK_GOLDEN_ROD_INT = 0xB8860B;

  public static final String DARK_GOLDEN_ROD_STRING = "DarkGoldenRod";

  public static final Color DARK_GOLDEN_ROD = Color.fromLong(DARK_GOLDEN_ROD_INT);

  public static final int DARK_GREY_INT = 0xA9A9A9;

  public static final String DARK_GREY_STRING = "DarkGrey";

  public static final Color DARK_GREY = Color.fromLong(DARK_GREY_INT);

  public static final int DARK_GREEN_INT = 0x006400;

  public static final String DARK_GREEN_STRING = "DarkGreen";

  public static final Color DARK_GREEN = Color.fromLong(DARK_GREEN_INT);

  public static final int DARK_KHAKI_INT = 0xBDB76B;

  public static final String DARK_KHAKI_STRING = "DarkKhaki";

  public static final Color DARK_KHAKI = Color.fromLong(DARK_KHAKI_INT);

  public static final int DARK_MAGENTA_INT = 0x8B008B;

  public static final String DARK_MAGENTA_STRING = "DarkMagenta";

  public static final Color DARK_MAGENTA = Color.fromLong(DARK_MAGENTA_INT);

  public static final int DARK_OLIVE_GREEN_INT = 0x556B2F;

  public static final String DARK_OLIVE_GREEN_STRING = "DarkOliveGreen";

  public static final Color DARK_OLIVE_GREEN = Color.fromLong(DARK_OLIVE_GREEN_INT);

  public static final int DARK_ORANGE_INT = 0xFF8C00;

  public static final String DARK_ORANGE_STRING = "DarkOrange";

  public static final Color DARK_ORANGE = Color.fromLong(DARK_ORANGE_INT);

  public static final int DARK_ORCHID_INT = 0x9932CC;

  public static final String DARK_ORCHID_STRING = "DarkOrchid";

  public static final Color DARK_ORCHID = Color.fromLong(DARK_ORCHID_INT);

  public static final int DARK_RED_INT = 0x8B0000;

  public static final String DARK_RED_STRING = "DarkRed";

  public static final Color DARK_RED = Color.fromLong(DARK_RED_INT);

  public static final int DARK_SALMON_INT = 0xE9967A;

  public static final String DARK_SALMON_STRING = "DarkSalmon";

  public static final Color DARK_SALMON = Color.fromLong(DARK_SALMON_INT);

  public static final int DARK_SEA_GREEN_INT = 0x8FBC8F;

  public static final String DARK_SEA_GREEN_STRING = "DarkSeaGreen";

  public static final Color DARK_SEA_GREEN = Color.fromLong(DARK_SEA_GREEN_INT);

  public static final int DARK_SLATE_BLUE_INT = 0x483D8B;

  public static final String DARK_SLATE_BLUE_STRING = "DarkSlateBlue";

  public static final Color DARK_SLATE_BLUE = Color.fromLong(DARK_SLATE_BLUE_INT);

  public static final int DARK_SLATE_GREY_INT = 0x2F4F4F;

  public static final String DARK_SLATE_GREY_STRING = "DarkSlateGrey";

  public static final Color DARK_SLATE_GREY = Color.fromLong(DARK_SLATE_GREY_INT);

  public static final int DARK_TURQUOISE_INT = 0x00CED1;

  public static final String DARK_TURQUOISE_STRING = "DarkTurquoise";

  public static final Color DARK_TURQUOISE = Color.fromLong(DARK_TURQUOISE_INT);

  public static final int DARK_VIOLET_INT = 0x9400D3;

  public static final String DARK_VIOLET_STRING = "DarkViolet";

  public static final Color DARK_VIOLET = Color.fromLong(DARK_VIOLET_INT);

  public static final int DEEP_PINK_INT = 0xFF1493;

  public static final String DEEP_PINK_STRING = "DeepPink";

  public static final Color DEEP_PINK = Color.fromLong(DEEP_PINK_INT);

  public static final int DEEP_SKY_BLUE_INT = 0x00BFFF;

  public static final String DEEP_SKY_BLUE_STRING = "DeepSkyBlue";

  public static final Color DEEP_SKY_BLUE = Color.fromLong(DEEP_SKY_BLUE_INT);

  public static final int DIM_GREY_INT = 0x696969;

  public static final String DIM_GREY_STRING = "DimGrey";

  public static final Color DIM_GREY = Color.fromLong(DIM_GREY_INT);

  public static final int DODGER_BLUE_INT = 0x1E90FF;

  public static final String DODGER_BLUE_STRING = "DodgetBlue";

  public static final Color DODGER_BLUE = Color.fromLong(DODGER_BLUE_INT);

  public static final int FIREBRICK_INT = 0xB22222;

  public static final String FIREBRICK_STRING = "FireBrick";

  public static final Color FIREBRICK = Color.fromLong(FIREBRICK_INT);

  public static final int FLORAL_WHITE_INT = 0xFFFAF0;

  public static final String FLORAL_WHITE_STRING = "FloralWhite";

  public static final Color FLORAL_WHITE = Color.fromLong(FLORAL_WHITE_INT);

  public static final int FOREST_GREEN_INT = 0x228B22;

  public static final String FOREST_GREEN_STRING = "ForestGreen";

  public static final Color FOREST_GREEN = Color.fromLong(FOREST_GREEN_INT);

  public static final int FUCHSIA_INT = 0xFF00FF;

  public static final String FUCHSIA_STRING = "Fuchsia";

  public static final Color FUCHSIA = Color.fromLong(FUCHSIA_INT);

  public static final int GAINSBORO_INT = 0xDCDCDC;

  public static final String GAINSBORO_STRING = "Gainsboro";

  public static final Color GAINSBORO = Color.fromLong(GAINSBORO_INT);

  public static final int GHOST_WHITE_INT = 0xF8F8FF;

  public static final String GHOST_WHITE_STRING = "GhostWhite";

  public static final Color GHOST_WHITE = Color.fromLong(GHOST_WHITE_INT);

  public static final int GOLD_INT = 0xFFD700;

  public static final String GOLD_STRING = "Gold";

  public static final Color GOLD = Color.fromLong(GOLD_INT);

  public static final int GOLDEN_ROD_INT = 0xDAA520;

  public static final String GOLDEN_ROD_STRING = "GoldenRod";

  public static final Color GOLDEN_ROD = Color.fromLong(GOLDEN_ROD_INT);

  public static final int GREY_INT = 0x808080;

  public static final String GREY_STRING = "Grey";

  public static final Color GREY = Color.fromLong(GREY_INT);

  public static final int GREEN_INT = 0x008000;

  public static final String GREEN_STRING = "Green";

  public static final Color GREEN = Color.fromLong(GREEN_INT);

  public static final int GREEN_YELLOW_INT = 0xADFF2F;

  public static final String GREEN_YELLOW_STRING = "GreenYellow";

  public static final Color GREEN_YELLOW = Color.fromLong(GREEN_YELLOW_INT);

  public static final int HONEY_DEW_INT = 0xF0FFF0;

  public static final String HONEY_DEW_STRING = "HoneyDew";

  public static final Color HONEY_DEW = Color.fromLong(HONEY_DEW_INT);

  public static final int HOT_PINK_INT = 0xFF69B4;

  public static final String HOT_PINK_STRING = "HotPink";

  public static final Color HOT_PINK = Color.fromLong(HOT_PINK_INT);

  public static final int INDIAN_RED_INT = 0xCD5C5C;

  public static final String INDIAN_RED_STRING = "IndianRed";

  public static final Color INDIAN_RED = Color.fromLong(INDIAN_RED_INT);

  public static final int INDIGO_INT = 0x4B0082;

  public static final String INDIGO_STRING = "Indigo";

  public static final Color INDIGO = Color.fromLong(INDIGO_INT);

  public static final int IVORY_INT = 0xFFFFF0;

  public static final String IVORY_STRING = "Ivory";

  public static final Color IVORY = Color.fromLong(IVORY_INT);

  public static final int KHAKI_INT = 0xF0E68C;

  public static final String KHAKI_STRING = "Khaki";

  public static final Color KHAKI = Color.fromLong(KHAKI_INT);

  public static final int LAVENDER_INT = 0xE6E6FA;

  public static final String LAVENDER_STRING = "Lavender";

  public static final Color LAVENDER = Color.fromLong(LAVENDER_INT);

  public static final int LAVENDER_BLUSH_INT = 0xFFF0F5;

  public static final String LAVENDER_BLUSH_STRING = "LavenderBlush";

  public static final Color LAVENDER_BLUSH = Color.fromLong(LAVENDER_BLUSH_INT);

  public static final int LAWN_GREEN_INT = 0x7CFC00;

  public static final String LAWN_GREEN_STRING = "LawnGreen";

  public static final Color LAWN_GREEN = Color.fromLong(LAWN_GREEN_INT);

  public static final int LEMON_CHIFFON_INT = 0xFFFACD;

  public static final String LEMON_CHIFFON_STRING = "LemonChiffon";

  public static final Color LEMON_CHIFFON = Color.fromLong(LEMON_CHIFFON_INT);

  public static final int LIGHT_BLUE_INT = 0xADD8E6;

  public static final String LIGHT_BLUE_STRING = "LightBlue";

  public static final Color LIGHT_BLUE = Color.fromLong(LIGHT_BLUE_INT);

  public static final int LIGHT_CORAL_INT = 0xF08080;

  public static final String LIGHT_CORAL_STRING = "LightCoral";

  public static final Color LIGHT_CORAL = Color.fromLong(LIGHT_CORAL_INT);

  public static final int LIGHT_CYAN_INT = 0xE0FFFF;

  public static final String LIGHT_CYAN_STRING = "LightCyan";

  public static final Color LIGHT_CYAN = Color.fromLong(LIGHT_CYAN_INT);

  public static final int LIGHT_GOLDEN_ROD_YELLOW_INT = 0xFAFAD2;

  public static final String LIGHT_GOLDEN_ROD_YELLOW_STRING = "LightGoldenRodYellow";

  public static final Color LIGHT_GOLDEN_ROD_YELLOW = Color.fromLong(LIGHT_GOLDEN_ROD_YELLOW_INT);

  public static final int LIGHT_GREY_INT = 0xD3D3D3;

  public static final String LIGHT_GREY_STRING = "LightGrey";

  public static final Color LIGHT_GREY = Color.fromLong(LIGHT_GREY_INT);

  public static final int LIGHT_GREEN_INT = 0x90EE90;

  public static final String LIGHT_GREEN_STRING = "LightGreen";

  public static final Color LIGHT_GREEN = Color.fromLong(LIGHT_GREEN_INT);

  public static final int LIGHT_PINK_INT = 0xFFB6C1;

  public static final String LIGHT_PINK_STRING = "LightPink";

  public static final Color LIGHT_PINK = Color.fromLong(LIGHT_PINK_INT);

  public static final int LIHGT_SALMON_INT = 0xFFA07A;

  public static final String LIHGT_SALMON_STRING = "LightSalmon";

  public static final Color LIHGT_SALMON = Color.fromLong(LIHGT_SALMON_INT);

  public static final int LIGHT_SEA_GREEN_INT = 0x20B2AA;

  public static final String LIGHT_SEA_GREEN_STRING = "LightSeaGreen";

  public static final Color LIGHT_SEA_GREEN = Color.fromLong(LIGHT_SEA_GREEN_INT);

  public static final int LIGHT_SKY_BLUE_INT = 0x87CEFA;

  public static final String LIGHT_SKY_BLUE_STRING = "LightSkyBlue";

  public static final Color LIGHT_SKY_BLUE = Color.fromLong(LIGHT_SKY_BLUE_INT);

  public static final int LIGHT_SLATE_GREY_INT = 0x778899;

  public static final String LIGHT_SLATE_GREY_STRING = "LightSlateGrey";

  public static final Color LIGHT_SLATE_GREY = Color.fromLong(LIGHT_SLATE_GREY_INT);

  public static final int LIGHT_STEEL_BLUE_INT = 0xB0C4DE;

  public static final String LIGHT_STEEL_BLUE_STRING = "LightSteelBlue";

  public static final Color LIGHT_STEEL_BLUE = Color.fromLong(LIGHT_STEEL_BLUE_INT);

  public static final int LIGHT_YELLOW_INT = 0xFFFFE0;

  public static final String LIGHT_YELLOW_STRING = "LightYellow";

  public static final Color LIGHT_YELLOW = Color.fromLong(LIGHT_YELLOW_INT);

  public static final int LIME_INT = 0x00FF00;

  public static final String LIME_STRING = "Lime";

  public static final Color LIME = Color.fromLong(LIME_INT);

  public static final int LIME_GREEN_INT = 0x32CD32;

  public static final String LIME_GREEN_STRING = "LimeGreen";

  public static final Color LIME_GREEN = Color.fromLong(LIME_GREEN_INT);

  public static final int LINEN_INT = 0xFAF0E6;

  public static final String LINEN_STRING = "Linen";

  public static final Color LINEN = Color.fromLong(LINEN_INT);

  public static final int MAGENTA_INT = 0xFF00FF;

  public static final String MAGENTA_STRING = "Magenta";

  public static final Color MAGENTA = Color.fromLong(MAGENTA_INT);

  public static final int MAROON_INT = 0x800000;

  public static final String MAROON_STRING = "Maroon";

  public static final Color MAROON = Color.fromLong(MAROON_INT);

  public static final int MEDIUM_AQUA_MARINE_INT = 0x66CDAA;

  public static final String MEDIUM_AQUA_MARINE_STRING = "MediumAquaMarine";

  public static final Color MEDIUM_AQUA_MARINE = Color.fromLong(MEDIUM_AQUA_MARINE_INT);

  public static final int MEDIUM_BLUE_INT = 0x0000CD;

  public static final String MEDIUM_BLUE_STRING = "MediumBlue";

  public static final Color MEDIUM_BLUE = Color.fromLong(MEDIUM_BLUE_INT);

  public static final int MEDIUM_ORCHID_INT = 0xBA55D3;

  public static final String MEDIUM_ORCHID_STRING = "";

  public static final Color MEDIUM_ORCHID = Color.fromLong(MEDIUM_ORCHID_INT);

  public static final int MEDIUM_PURPLE_INT = 0x9370DB;

  public static final String MEDIUM_PURPLE_STRING = "MediumPurple";

  public static final Color MEDIUM_PURPLE = Color.fromLong(MEDIUM_PURPLE_INT);

  public static final int MEDIUM_SEA_GREEN_INT = 0x3CB371;

  public static final String MEDIUM_SEA_GREEN_STRING = "";

  public static final Color MEDIUM_SEA_GREEN = Color.fromLong(MEDIUM_SEA_GREEN_INT);

  public static final int MEDIUM_SLATE_BLUE_INT = 0x7B68EE;

  public static final String MEDIUM_SLATE_BLUE_STRING = "MediumSlateBlue";

  public static final Color MEDIUM_SLATE_BLUE = Color.fromLong(MEDIUM_SLATE_BLUE_INT);

  public static final int MEDIUM_SPRING_GREEN_INT = 0x00FA9A;

  public static final String MEDIUM_SPRING_GREEN_STRING = "";

  public static final Color MEDIUM_SPRING_GREEN = Color.fromLong(MEDIUM_SPRING_GREEN_INT);

  public static final int MEDIUM_TURQUOISE_INT = 0x48D1CC;

  public static final String MEDIUM_TURQUOISE_STRING = "MediumTurquoise";

  public static final Color MEDIUM_TURQUOISE = Color.fromLong(MEDIUM_TURQUOISE_INT);

  public static final int MEDIUM_VIOLET_RED_INT = 0xC71585;

  public static final String MEDIUM_VIOLET_RED_STRING = "MediumVioletRed";

  public static final Color MEDIUM_VIOLET_RED = Color.fromLong(MEDIUM_VIOLET_RED_INT);

  public static final int MIDNIGHT_BLUE_INT = 0x191970;

  public static final String MIDNIGHT_BLUE_STRING = "MidnightBlue";

  public static final Color MIDNIGHT_BLUE = Color.fromLong(MIDNIGHT_BLUE_INT);

  public static final int MINT_CREAM_INT = 0xF5FFFA;

  public static final String MINT_CREAM_STRING = "MintCream";

  public static final Color MINT_CREAM = Color.fromLong(MINT_CREAM_INT);

  public static final int MISTY_ROSE_INT = 0xFFE4E1;

  public static final String MISTY_ROSE_STRING = "MistyRose";

  public static final Color MISTY_ROSE = Color.fromLong(MISTY_ROSE_INT);

  public static final int MOCCASIN_INT = 0xFFE4B5;

  public static final String MOCCASIN_STRING = "Moccasin";

  public static final Color MOCCASIN = Color.fromLong(MOCCASIN_INT);

  public static final int NAVAJO_WHITE_INT = 0xFFDEAD;

  public static final String NAVAJO_WHITE_STRING = "NavajoWhite";

  public static final Color NAVAJO_WHITE = Color.fromLong(NAVAJO_WHITE_INT);

  public static final int NAVY_INT = 0x000080;

  public static final String NAVY_STRING = "Navy";

  public static final Color NAVY = Color.fromLong(NAVY_INT);

  public static final int OLD_LACE_INT = 0xFDF5E6;

  public static final String OLD_LACE_STRING = "OldLace";

  public static final Color OLD_LACE = Color.fromLong(OLD_LACE_INT);

  public static final int OLIVE_INT = 0x808000;

  public static final String OLIVE_STRING = "Olive";

  public static final Color OLIVE = Color.fromLong(OLIVE_INT);

  public static final int OLIVE_DRAB_INT = 0x6B8E23;

  public static final String OLIVE_DRAB_STRING = "OliveDrab";

  public static final Color OLIVE_DRAB = Color.fromLong(OLIVE_DRAB_INT);

  public static final int ORANGE_INT = 0xFFA500;

  public static final String ORANGE_STRING = "Orange";

  public static final Color ORANGE = Color.fromLong(ORANGE_INT);

  public static final int ORANGE_RED_INT = 0xFF4500;

  public static final String ORANGE_RED_STRING = "OrangeRed";

  public static final Color ORANGE_RED = Color.fromLong(ORANGE_RED_INT);

  public static final int ORCHID_INT = 0xDA70D6;

  public static final String ORCHID_STRING = "Orchid";

  public static final Color ORCHID = Color.fromLong(ORCHID_INT);

  public static final int PALE_GOLDEN_ROD_INT = 0xEEE8AA;

  public static final String PALE_GOLDEN_ROD_STRING = "PaleGoldenRod";

  public static final Color PALE_GOLDEN_ROD = Color.fromLong(PALE_GOLDEN_ROD_INT);

  public static final int PALE_GREEN_INT = 0x98FB98;

  public static final String PALE_GREEN_STRING = "PaleGreen";

  public static final Color PALE_GREEN = Color.fromLong(PALE_GREEN_INT);

  public static final int PALE_TURQUOISE_INT = 0xAFEEEE;

  public static final String PALE_TURQUOISE_STRING = "PaleTurquoise";

  public static final Color PALE_TURQUOISE = Color.fromLong(PALE_TURQUOISE_INT);

  public static final int PALE_VIOLET_RED_INT = 0xDB7093;

  public static final String PALE_VIOLET_RED_STRING = "PaleVioletRed";

  public static final Color PALE_VIOLET_RED = Color.fromLong(PALE_VIOLET_RED_INT);

  public static final int PAPAYA_WHIP_INT = 0xFFEFD5;

  public static final String PAPAYA_WHIP_STRING = "PapayaWhip";

  public static final Color PAPAYA_WHIP = Color.fromLong(PAPAYA_WHIP_INT);

  public static final int PEACH_PUFF_INT = 0xFFDAB9;

  public static final String PEACH_PUFF_STRING = "PeachPuff";

  public static final Color PEACH_PUFF = Color.fromLong(PEACH_PUFF_INT);

  public static final int PERU_INT = 0xCD853F;

  public static final String PERU_STRING = "Peru";

  public static final Color PERU = Color.fromLong(PERU_INT);

  public static final int PINK_INT = 0xFFC0CB;

  public static final String PINK_STRING = "Pink";

  public static final Color PINK = Color.fromLong(PINK_INT);

  public static final int PLUM_INT = 0xDDA0DD;

  public static final String PLUM_STRING = "Plum";

  public static final Color PLUM = Color.fromLong(PLUM_INT);

  public static final int POWDER_BLUE_INT = 0xB0E0E6;

  public static final String POWDER_BLUE_STRING = "PowderBlue";

  public static final Color POWDER_BLUE = Color.fromLong(POWDER_BLUE_INT);

  public static final int PURPLE_INT = 0x800080;

  public static final String PURPLE_STRING = "Purple";

  public static final Color PURPLE = Color.fromLong(PURPLE_INT);

  public static final int REBECCA_PURPLE_INT = 0x663399;

  public static final String REBECCA_PURPLE_STRING = "RebeccaPurple";

  public static final Color REBECCA_PURPLE = Color.fromLong(REBECCA_PURPLE_INT);

  public static final int RED_INT = 0xFF0000;

  public static final String RED_STRING = "Red";

  public static final Color RED = Color.fromLong(RED_INT);

  public static final int ROSY_BROWN_INT = 0xBC8F8F;

  public static final String ROSY_BROWN_STRING = "RosyBrown";

  public static final Color ROSY_BROWN = Color.fromLong(ROSY_BROWN_INT);

  public static final int ROYAL_BLUE_INT = 0x4169E1;

  public static final String ROYAL_BLUE_STRING = "RoyalBlue";

  public static final Color ROYAL_BLUE = Color.fromLong(ROYAL_BLUE_INT);

  public static final int SADDLE_BROWN_INT = 0x8B4513;

  public static final String SADDLE_BROWN_STRING = "SaddleBrown";

  public static final Color SADDLE_BROWN = Color.fromLong(SADDLE_BROWN_INT);

  public static final int SALMON_INT = 0xFA8072;

  public static final String SALMON_STRING = "Salmon";

  public static final Color SALMON = Color.fromLong(SALMON_INT);

  public static final int SANDY_BROWN_INT = 0xF4A460;

  public static final String SANDY_BROWN_STRING = "SandyBrown";

  public static final Color SANDY_BROWN = Color.fromLong(SANDY_BROWN_INT);

  public static final int SEA_GREEN_INT = 0x2E8B57;

  public static final String SEA_GREEN_STRING = "SeaGreen";

  public static final Color SEA_GREEN = Color.fromLong(SEA_GREEN_INT);

  public static final int SEA_SHELL_INT = 0xFFF5EE;

  public static final String SEA_SHELL_STRING = "SeaShell";

  public static final Color SEA_SHELL = Color.fromLong(SEA_SHELL_INT);

  public static final int SIENNA_INT = 0xA0522D;

  public static final String SIENNA_STRING = "Sienna";

  public static final Color SIENNA = Color.fromLong(SIENNA_INT);

  public static final int SILVER_INT = 0xC0C0C0;

  public static final String SILVER_STRING = "Silver";

  public static final Color SILVER = Color.fromLong(SILVER_INT);

  public static final int SKY_BLUE_INT = 0x87CEEB;

  public static final String SKY_BLUE_STRING = "SkyBlue";

  public static final Color SKY_BLUE = Color.fromLong(SKY_BLUE_INT);

  public static final int SLATE_BLUE_INT = 0x6A5ACD;

  public static final String SLATE_BLUE_STRING = "SlateBlue";

  public static final Color SLATE_BLUE = Color.fromLong(SLATE_BLUE_INT);

  public static final int SLATE_GREY_INT = 0x708090;

  public static final String SLATE_GREY_STRING = "SlateGrey";

  public static final Color SLATE_GREY = Color.fromLong(SLATE_GREY_INT);

  public static final int SNOW_INT = 0xFFFAFA;

  public static final String SNOW_STRING = "Snow";

  public static final Color SNOW = Color.fromLong(SNOW_INT);

  public static final int SPRING_GREEN_INT = 0x00FF7F;

  public static final String SPRING_GREEN_STRING = "SpringGreen";

  public static final Color SPRING_GREEN = Color.fromLong(SPRING_GREEN_INT);

  public static final int STEEL_BLUE_INT = 0x4682B4;

  public static final String STEEL_BLUE_STRING = "SteelBlue";

  public static final Color STEEL_BLUE = Color.fromLong(STEEL_BLUE_INT);

  public static final int TAN_INT = 0xD2B48C;

  public static final String TAN_STRING = "Tan";

  public static final Color TAN = Color.fromLong(TAN_INT);

  public static final int TEAL_INT = 0x008080;

  public static final String TEAL_STRING = "Teal";

  public static final Color TEAL = Color.fromLong(TEAL_INT);

  public static final int THISTLE_INT = 0xD8BFD8;

  public static final String THISTLE_STRING = "Thistle";

  public static final Color THISTLE = Color.fromLong(THISTLE_INT);

  public static final int TOMATO_INT = 0xFF6347;

  public static final String TOMATO_STRING = "Tomato";

  public static final Color TOMATO = Color.fromLong(TOMATO_INT);

  public static final int TURQUOISE_INT = 0x40E0D0;

  public static final String TURQUOISE_STRING = "Turquoise";

  public static final Color TURQUOISE = Color.fromLong(TURQUOISE_INT);

  public static final int VIOLET_INT = 0xEE82EE;

  public static final String VIOLET_STRING = "VIOLET";

  public static final Color VIOLET = Color.fromLong(VIOLET_INT);

  public static final int WHEAT_INT = 0xF5DEB3;

  public static final String WHEAT_STRING = "Wheat";

  public static final Color WHEAT = Color.fromLong(WHEAT_INT);

  public static final int WHITE_INT = 0xFFFFFF;

  public static final String WHITE_STRING = "White";

  public static final Color WHITE = Color.fromLong(WHITE_INT);

  public static final int WHITE_SMOKE_INT = 0xF5F5F5;

  public static final String WHITE_SMOKE_STRING = "WhiteSmoke";

  public static final Color WHITE_SMOKE = Color.fromLong(WHITE_SMOKE_INT);

  public static final int YELLOW_INT = 0xFFFF00;

  public static final String YELLOW_STRING = "Yellow";

  public static final Color YELLOW = Color.fromLong(YELLOW_INT);

  public static final int YELLOW_GREEN_INT = 0x9ACD32;

  public static final String YELLOW_GREEN_STRING = "YellowGreen";

  public static final Color YELLOW_GREEN = Color.fromLong(YELLOW_GREEN_INT);

  /**
   * Prevents that an instance of the {@link X11ColorCatalog} can be created.
   */
  private X11ColorCatalog() {
  }
}
