/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.linkedlist;

import ch.nolix.core.container.linkedlist.LinkedListNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.NoSuchElementException;

final class LinkedListIterator<E>
implements CopyableIterator<E> {
    private LinkedListNode<E> nextNode;

    private LinkedListIterator(LinkedListNode<E> nullableFirstNode) {
        this.nextNode = nullableFirstNode;
    }

    public static <T> LinkedListIterator<T> withNullableFirstNode(LinkedListNode<T> nullableFirstNode) {
        return new LinkedListIterator<T>(nullableFirstNode);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return LinkedListIterator.withNullableFirstNode(this.nextNode);
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element").toNoSuchElementException();
        }
    }

    private E nextWhenHasNext() {
        E element = this.nextNode.getElement();
        this.nextNode = this.nextNode.hasNextNode() ? this.nextNode.getNextNode() : null;
        return element;
    }
}

